/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

public class SubspaceManhattanDistanceFunction
extends SubspaceLPNormDistanceFunction {
    public SubspaceManhattanDistanceFunction(long[] lArray) {
        super(1.0, lArray);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (numberVector.getDimensionality() != numberVector2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of FeatureVectors\n  first argument: " + numberVector + "\n  " + "second argument: " + numberVector2);
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            d += Math.abs(numberVector.doubleValue(n) - numberVector2.doubleValue(n));
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return d;
    }

    @Override
    protected double minDistObject(SpatialComparable spatialComparable, NumberVector numberVector) {
        if (spatialComparable.getDimensionality() != numberVector.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + numberVector.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2;
            double d3 = numberVector.doubleValue(n);
            if (d3 < (d2 = spatialComparable.getMin(n))) {
                d += d2 - d3;
            } else {
                double d4 = spatialComparable.getMax(n);
                if (d3 > d4) {
                    d += d3 - d4;
                }
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable.getDimensionality() != spatialComparable2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + spatialComparable2.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2;
            double d3 = spatialComparable.getMax(n);
            if (d3 < (d2 = spatialComparable2.getMin(n))) {
                d += d2 - d3;
            } else {
                double d4;
                double d5 = spatialComparable.getMin(n);
                if (d5 > (d4 = spatialComparable2.getMax(n))) {
                    d += d5 - d4;
                }
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return d;
    }

    @Override
    public double norm(NumberVector numberVector) {
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            d += Math.abs(numberVector.doubleValue(n));
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return d;
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        @Override
        protected SubspaceManhattanDistanceFunction makeInstance() {
            return new SubspaceManhattanDistanceFunction(this.dimensions);
        }
    }
}

