/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="E. Hellinger", title="Neue Begr\u00fcndung der Theorie quadratischer Formen von unendlichvielen Ver\u00e4nderlichen", booktitle="Journal f\u00fcr die reine und angewandte Mathematik ", url="http://resolver.sub.uni-goettingen.de/purl?GDZPPN002166941")
@Alias(value={"hellinger", "bhattacharyya"})
public class HellingerDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements PrimitiveSimilarityFunction<NumberVector> {
    public static final HellingerDistanceFunction STATIC = new HellingerDistanceFunction();

    @Deprecated
    public HellingerDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2;
        int n3 = numberVector.getDimensionality();
        int n4 = n3 < (n2 = numberVector2.getDimensionality()) ? n3 : n2;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            double d2 = Math.sqrt(numberVector.doubleValue(n)) - Math.sqrt(numberVector2.doubleValue(n));
            d += d2 * d2;
        }
        for (n = n4; n < n3; ++n) {
            d += Math.abs(numberVector.doubleValue(n));
        }
        for (n = n4; n < n2; ++n) {
            d += Math.abs(numberVector2.doubleValue(n));
        }
        return MathUtil.SQRTHALF * Math.sqrt(d);
    }

    @Override
    public double similarity(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = n2 < (n = numberVector2.getDimensionality()) ? n2 : n;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            d += Math.sqrt(numberVector.doubleValue(i) * numberVector2.doubleValue(i));
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public <T extends NumberVector> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<NumberVector>(relation, this, this);
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HellingerDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

