/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.OnDiskUpperTriangleMatrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;

@Title(value="File based double distance for database objects.")
@Description(value="Loads double distance values from an external matrix.")
public class DiskCacheBasedDoubleDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(DiskCacheBasedDoubleDistanceFunction.class);
    public static final int DOUBLE_CACHE_MAGIC = 50902811;
    private OnDiskUpperTriangleMatrix cache;

    public DiskCacheBasedDoubleDistanceFunction(OnDiskUpperTriangleMatrix onDiskUpperTriangleMatrix) {
        this.cache = onDiskUpperTriangleMatrix;
    }

    public DiskCacheBasedDoubleDistanceFunction(File file) throws IOException {
        this.cache = new OnDiskUpperTriangleMatrix(file, 50902811, 0, 8, false);
    }

    @Override
    public double distance(int n, int n2) {
        if (n > n2) {
            return this.distance(n2, n);
        }
        try {
            return this.cache.getRecordBuffer(n, n2).getDouble();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Read error when loading distance " + n + "," + n2 + " from cache file.", iOException);
        }
    }

    @Override
    public void checkRange(DBIDRange dBIDRange) {
        if (this.cache.getMatrixSize() < dBIDRange.size()) {
            LOG.warning("Distance matrix has size " + this.cache.getMatrixSize() + " but range has size: " + dBIDRange.size());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DiskCacheBasedDoubleDistanceFunction diskCacheBasedDoubleDistanceFunction = (DiskCacheBasedDoubleDistanceFunction)object;
        return this.cache.equals(diskCacheBasedDoubleDistanceFunction.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = new OptionID("distance.matrix", "The name of the file containing the distance matrix.");
        protected OnDiskUpperTriangleMatrix cache = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                File file = (File)fileParameter.getValue();
                try {
                    this.cache = new OnDiskUpperTriangleMatrix(file, 50902811, 0, 8, false);
                }
                catch (IOException iOException) {
                    parameterization.reportError(new WrongParameterValueException(fileParameter, file.toString(), iOException));
                }
            }
        }

        @Override
        protected DiskCacheBasedDoubleDistanceFunction makeInstance() {
            return new DiskCacheBasedDoubleDistanceFunction(this.cache);
        }
    }
}

