/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Title(value="Color histogram intersection distance")
@Description(value="Distance function for color histograms that emphasizes 'strong' bins.")
@Reference(authors="M. J. Swain, D. H. Ballard", title="Color Indexing", booktitle="International Journal of Computer Vision, 7(1), 32, 1991")
public class HistogramIntersectionDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final HistogramIntersectionDistanceFunction STATIC = new HistogramIntersectionDistanceFunction();

    @Deprecated
    public HistogramIntersectionDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = HistogramIntersectionDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = numberVector.doubleValue(i);
            double d5 = numberVector2.doubleValue(i);
            d += Math.min(d4, d5);
            d2 += d4;
            d3 += d5;
        }
        return 1.0 - d / Math.min(d2, d3);
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = HistogramIntersectionDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = spatialComparable.getMin(i);
            double d5 = spatialComparable.getMax(i);
            double d6 = spatialComparable2.getMin(i);
            double d7 = spatialComparable2.getMax(i);
            d += Math.min(d5, d7);
            d2 += d4;
            d3 += d6;
        }
        return 1.0 - d / Math.min(d2, d3);
    }

    public String toString() {
        return "HistogramIntersectionDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass().equals(object.getClass());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HistogramIntersectionDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

