/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza and E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances")
public class ClarkDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final ClarkDistanceFunction STATIC = new ClarkDistanceFunction();

    @Deprecated
    public ClarkDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2;
        int n3 = numberVector.getDimensionality();
        int n4 = n3 < (n2 = numberVector2.getDimensionality()) ? n3 : n2;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            double d2 = numberVector.doubleValue(n);
            double d3 = numberVector2.doubleValue(n);
            double d4 = Math.abs(d2) + Math.abs(d3);
            if (!(d4 > 0.0)) continue;
            double d5 = (d2 - d3) / d4;
            d += d5 * d5;
        }
        for (n = n4; n < n3; ++n) {
            if (numberVector.doubleValue(n) == 0.0) continue;
            d += 1.0;
        }
        for (n = n4; n < n2; ++n) {
            if (numberVector2.doubleValue(n) == 0.0) continue;
            d += 1.0;
        }
        return Math.sqrt(d / (double)Math.max(n3, n2));
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n;
        int n2;
        int n3 = spatialComparable.getDimensionality();
        int n4 = n3 < (n2 = spatialComparable2.getDimensionality()) ? n3 : n2;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            double d2;
            double d3 = spatialComparable.getMin(n);
            double d4 = spatialComparable.getMax(n);
            double d5 = spatialComparable2.getMin(n);
            double d6 = spatialComparable2.getMax(n);
            if (d4 < d5) {
                d2 = d5 - d4;
            } else {
                if (!(d3 > d6)) continue;
                d2 = d3 - d6;
            }
            double d7 = Math.max(-d3, d4);
            double d8 = Math.max(-d5, d6);
            double d9 = d2 / (d7 + d8);
            d += d9 * d9;
        }
        for (n = n4; n < n3; ++n) {
            if (!(spatialComparable.getMin(n) > 0.0) && !(spatialComparable.getMax(n) < 0.0)) continue;
            d += 1.0;
        }
        for (n = n4; n < n2; ++n) {
            if (!(spatialComparable2.getMin(n) > 0.0) && !(spatialComparable2.getMax(n) < 0.0)) continue;
            d += 1.0;
        }
        return Math.sqrt(d / (double)Math.max(n3, n2));
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ClarkDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

