/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UncertainifyFilter<UO extends UncertainObject>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(UncertainifyFilter.class);
    protected Uncertainifier<UO> generator;
    protected boolean keep;
    protected Random rand;

    public UncertainifyFilter(Uncertainifier<UO> uncertainifier, boolean bl, RandomFactory randomFactory) {
        this.generator = uncertainifier;
        this.keep = bl;
        this.rand = randomFactory.getSingleThreadedRandom();
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(simpleTypeInformation)) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
                continue;
            }
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
            int n = vectorFieldTypeInformation.getDimensionality();
            if (this.keep) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
            }
            ArrayList<UO> arrayList = new ArrayList<UO>(list.size());
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Derive uncertain objects", multipleObjectsBundle.dataLength(), LOG) : null;
            for (int j = 0; j < multipleObjectsBundle.dataLength(); ++j) {
                NumberVector numberVector = (NumberVector)list.get(j);
                UO UO = this.generator.newFeatureVector(this.rand, numberVector, ArrayLikeUtil.NUMBERVECTORADAPTER);
                arrayList.add(UO);
                LOG.incrementProcessed(finiteProgress);
            }
            LOG.ensureCompleted(finiteProgress);
            multipleObjectsBundle2.appendColumn(new VectorFieldTypeInformation<UO>(this.generator.getFactory(), n), arrayList);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer<UO extends UncertainObject>
    extends AbstractParameterizer {
        public static final OptionID UNCERTAINITY_MODEL_ID = new OptionID("uofilter.generator", "Generator to derive uncertain objects from certain vectors.");
        public static final OptionID KEEP_ID = new OptionID("uofilter.keep", "Keep the original data as well.");
        public static final OptionID SEED_ID = new OptionID("uofilter.seed", "Random seed for uncertainification.");
        protected Uncertainifier<UO> generator;
        protected boolean keep;
        protected RandomFactory rand;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            Flag flag;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(UNCERTAINITY_MODEL_ID, Uncertainifier.class);
            if (parameterization.grab(objectParameter)) {
                this.generator = (Uncertainifier)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag = new Flag(KEEP_ID))) {
                this.keep = flag.isTrue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rand = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected UncertainifyFilter<UO> makeInstance() {
            return new UncertainifyFilter<UO>(this.generator, this.keep, this.rand);
        }
    }
}

