/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ExternalIDFilter"})
public class ExternalIDFilter
implements ObjectFilter {
    private final int externalIdIndex;

    public ExternalIDFilter(int n) {
        this.externalIdIndex = n;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            if (bl || !LabelList.class.equals(simpleTypeInformation.getRestrictionClass())) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, multipleObjectsBundle.getColumn(i));
                continue;
            }
            bl = true;
            ArrayList<ExternalID> arrayList = new ArrayList<ExternalID>(multipleObjectsBundle.dataLength());
            ArrayList<LabelList> arrayList2 = new ArrayList<LabelList>(multipleObjectsBundle.dataLength());
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Object obj : multipleObjectsBundle.getColumn(i)) {
                if (obj != null) {
                    LabelList labelList = (LabelList)obj;
                    int n = this.externalIdIndex >= 0 ? this.externalIdIndex : labelList.size() - this.externalIdIndex;
                    arrayList.add(new ExternalID(labelList.get(n)));
                    arrayList3.clear();
                    for (int j = 0; j < labelList.size(); ++j) {
                        if (j == n) continue;
                        arrayList3.add(labelList.get(j));
                    }
                    arrayList2.add(LabelList.make(arrayList3));
                    if (labelList.size() <= 0) continue;
                    bl2 = true;
                    continue;
                }
                arrayList.add(null);
                arrayList2.add(null);
            }
            multipleObjectsBundle2.appendColumn(TypeUtil.EXTERNALID, arrayList);
            if (!bl2) continue;
            multipleObjectsBundle2.appendColumn(simpleTypeInformation, arrayList2);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EXTERNALID_INDEX_ID = new OptionID("dbc.externalIdIndex", "The index of the label to be used as external Id. The first label is 0; negative indexes are relative to the end.");
        int externalIdIndex = -1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(EXTERNALID_INDEX_ID);
            if (parameterization.grab(intParameter)) {
                this.externalIdIndex = intParameter.intValue();
            }
        }

        @Override
        protected ExternalIDFilter makeInstance() {
            return new ExternalIDFilter(this.externalIdIndex);
        }
    }
}

