/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

public class NumberVectorRandomFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    protected long[] selectedAttributes = null;
    protected int k;
    protected RandomFactory rnd;

    public NumberVectorRandomFeatureSelectionFilter(int n, RandomFactory randomFactory) {
        this.k = n;
        this.rnd = randomFactory;
    }

    @Override
    protected V filterSingleObject(V v) {
        return VectorUtil.project(v, this.selectedAttributes, this.factory);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        this.initializeRandomAttributes(simpleTypeInformation);
        this.initializeOutputType(simpleTypeInformation);
        return new VectorFieldTypeInformation(this.factory, this.k);
    }

    void initializeRandomAttributes(SimpleTypeInformation<V> simpleTypeInformation) {
        int n = ((VectorFieldTypeInformation)simpleTypeInformation).getDimensionality();
        this.selectedAttributes = Util.randomBitSet(this.k, n, this.rnd.getSingleThreadedRandom());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NUMBER_SELECTED_ATTRIBUTES_ID = new OptionID("randomprojection.numberselected", "number of selected attributes");
        public static final OptionID SEED_ID = new OptionID("randomprojection.seed", "Seed for random selection of projection attributes.");
        protected int k = 0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(NUMBER_SELECTED_ATTRIBUTES_ID, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected NumberVectorRandomFeatureSelectionFilter<DoubleVector> makeInstance() {
            return new NumberVectorRandomFeatureSelectionFilter<DoubleVector>(this.k, this.rnd);
        }
    }
}

