/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.datasource.filter.transform.AbstractSupervisedProjectionVectorFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Alias(value={"lda"})
@Reference(authors="R. A. Fisher", title="The use of multiple measurements in taxonomic problems", booktitle="Annals of eugenics 7.2 (1936)", url="http://dx.doi.org/10.1111/j.1469-1809.1936.tb02137.x")
public class LinearDiscriminantAnalysisFilter<V extends NumberVector>
extends AbstractSupervisedProjectionVectorFilter<V> {
    private static final Logging LOG = Logging.getLogger(LinearDiscriminantAnalysisFilter.class);

    public LinearDiscriminantAnalysisFilter(int n) {
        super(n);
    }

    @Override
    protected Matrix computeProjectionMatrix(List<V> list, List<? extends ClassLabel> list2, int n) {
        Map<ClassLabel, TIntList> map = this.partition(list2);
        ArrayList<ClassLabel> arrayList = new ArrayList<ClassLabel>(map.keySet());
        List<Centroid> list3 = this.computeCentroids(n, list, arrayList, map);
        Object object = new CovarianceMatrix(n);
        for (Centroid centroid : list3) {
            ((CovarianceMatrix)object).put(centroid);
        }
        Matrix matrix = ((CovarianceMatrix)object).destroyToSampleMatrix();
        object = new CovarianceMatrix(n);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Centroid centroid = list3.get(i);
            TIntIterator tIntIterator = map.get(arrayList.get(i)).iterator();
            while (tIntIterator.hasNext()) {
                Vector vector = ((NumberVector)list.get(tIntIterator.next())).getColumnVector().minusEquals(centroid);
                ((CovarianceMatrix)object).put(vector);
            }
        }
        Matrix matrix2 = ((CovarianceMatrix)object).destroyToSampleMatrix();
        if (matrix2.det() == 0.0) {
            matrix2.cheatToAvoidSingularity(1.0E-10);
        }
        object = matrix2.inverse().times(matrix);
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition((Matrix)object);
        SortedEigenPairs sortedEigenPairs = new SortedEigenPairs(eigenvalueDecomposition, false);
        return sortedEigenPairs.eigenVectors(this.tdim).transpose();
    }

    protected List<Centroid> computeCentroids(int n, List<V> list, List<ClassLabel> list2, Map<ClassLabel, TIntList> map) {
        int n2 = list2.size();
        ArrayList<Centroid> arrayList = new ArrayList<Centroid>(n2);
        for (int i = 0; i < n2; ++i) {
            Centroid centroid = new Centroid(n);
            TIntIterator tIntIterator = map.get(list2.get(i)).iterator();
            while (tIntIterator.hasNext()) {
                centroid.put((NumberVector)list.get(tIntIterator.next()));
            }
            arrayList.add(centroid);
        }
        return arrayList;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractSupervisedProjectionVectorFilter.Parameterizer<V> {
        @Override
        protected LinearDiscriminantAnalysisFilter<V> makeInstance() {
            return new LinearDiscriminantAnalysisFilter(this.tdim);
        }
    }
}

