/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LatLngToECEFFilter<V extends NumberVector>
extends AbstractStreamConversionFilter<V, V> {
    private NumberVector.Factory<V> factory;
    private EarthModel model;

    public LatLngToECEFFilter(EarthModel earthModel) {
        this.model = earthModel;
    }

    @Override
    protected V filterSingleObject(V v) {
        return this.factory.newNumberVector(this.model.latLngDegToECEF(v.doubleValue(0), v.doubleValue(1)));
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        this.factory = FilterUtil.guessFactory(simpleTypeInformation);
        return new VectorFieldTypeInformation<V>(this.factory, 3, 3, simpleTypeInformation.getSerializer());
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        private EarthModel model;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (parameterization.grab(objectParameter)) {
                this.model = (EarthModel)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected LatLngToECEFFilter<V> makeInstance() {
            return new LatLngToECEFFilter(this.model);
        }
    }
}

