/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SingularValueDecomposition;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Alias(value={"mds"})
public class ClassicMultidimensionalScalingTransform<O>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(ClassicMultidimensionalScalingTransform.class);
    PrimitiveDistanceFunction<? super O> dist = null;
    int tdim;

    public ClassicMultidimensionalScalingTransform(int n, PrimitiveDistanceFunction<? super O> primitiveDistanceFunction) {
        this.tdim = n;
        this.dist = primitiveDistanceFunction;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n = multipleObjectsBundle.dataLength();
        if (n == 0) {
            return multipleObjectsBundle;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            Object object;
            Object object2;
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!this.dist.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
                continue;
            }
            List<?> list2 = list;
            NumberVector.Factory<DoubleVector> factory = null;
            if (simpleTypeInformation instanceof VectorFieldTypeInformation) {
                object = object2 = (VectorFieldTypeInformation)simpleTypeInformation;
                factory = FilterUtil.guessFactory(object);
            } else {
                factory = DoubleVector.FACTORY;
            }
            multipleObjectsBundle2.appendColumn(new VectorFieldTypeInformation<DoubleVector>(factory, this.tdim), list2);
            object2 = new Matrix(this.computeDistanceMatrix(list2, n));
            ClassicMultidimensionalScalingTransform.doubleCenterSymmetric(((Matrix)object2).getArrayRef());
            object = new SingularValueDecomposition((Matrix)object2);
            Matrix matrix = ((SingularValueDecomposition)object).getU();
            double[] dArray = ((SingularValueDecomposition)object).getSingularValues();
            for (int j = 0; j < this.tdim; ++j) {
                dArray[j] = Math.sqrt(Math.abs(dArray[j]));
            }
            double[] dArray2 = new double[this.tdim];
            double[][] dArray3 = matrix.getArrayRef();
            for (int j = 0; j < n; ++j) {
                double[] dArray4 = dArray3[j];
                for (int k = 0; k < dArray2.length; ++k) {
                    dArray2[k] = dArray[k] * dArray4[k];
                }
                list.set(j, factory.newNumberVector(dArray2));
            }
        }
        return multipleObjectsBundle2;
    }

    protected double[][] computeDistanceMatrix(List<O> list, int n) {
        double[][] dArray = new double[n][n];
        boolean bl = this.dist instanceof SquaredEuclideanDistanceFunction;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing distance matrix", n * (n - 1) >>> 1, LOG) : null;
        for (int i = 0; i < n; ++i) {
            O o = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                O o2 = list.get(j);
                double d = this.dist.distance(o, o2);
                dArray[i][j] = d *= bl ? -0.5 : -0.5 * d;
                dArray[j][i] = d;
                LOG.incrementProcessed(finiteProgress);
            }
        }
        LOG.ensureCompleted(finiteProgress);
        return dArray;
    }

    public static void doubleCenterSymmetric(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            double d = dArray2[i] - dArray2[i] / (double)(i + 1);
            int n3 = i + 1;
            while (n3 < dArray3.length) {
                double d2 = dArray3[n3];
                double d3 = d2 - d;
                double d4 = d2 - dArray2[n3];
                d += d3 / (double)(n3 + 1);
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] + d4 / (double)(i + 1);
            }
            dArray2[i] = d;
        }
        double d = dArray2[0];
        for (n = 1; n < n2; ++n) {
            double d5 = dArray2[n] - d;
            d += d5 / (double)(n + 1);
        }
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = -2.0 * dArray2[n] + d;
            for (int i = n + 1; i < n2; ++i) {
                double d6;
                dArray[n][i] = d6 = dArray[n][i] - dArray2[n] - dArray2[i] + d;
                dArray[i][n] = d6;
            }
        }
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("mds.dim", "Output dimensionality.");
        public static final OptionID DISTANCE_ID = new OptionID("mds.distance", "Distance function to use.");
        int tdim;
        PrimitiveDistanceFunction<? super O> dist = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(DIM_ID);
            if (parameterization.grab(intParameter)) {
                this.tdim = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)PrimitiveDistanceFunction.class, SquaredEuclideanDistanceFunction.class))) {
                this.dist = (PrimitiveDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ClassicMultidimensionalScalingTransform<O> makeInstance() {
            return new ClassicMultidimensionalScalingTransform<O>(this.tdim, this.dist);
        }
    }
}

