/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.SortByLabelFilter"})
public class SortByLabelFilter
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(SortByLabelFilter.class);

    @Override
    public MultipleObjectsBundle filter(final MultipleObjectsBundle multipleObjectsBundle) {
        int n;
        if (LOG.isDebugging()) {
            LOG.debug("Shuffling the data set");
        }
        int n2 = multipleObjectsBundle.dataLength();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        n = FilterUtil.findLabelColumn(multipleObjectsBundle);
        if (n == -1) {
            throw new AbortException("No label column found - cannot sort by label.");
        }
        IntegerArrayQuickSort.sort(nArray, new IntegerComparator(){

            @Override
            public int compare(int n3, int n2) {
                String string = multipleObjectsBundle.data(n3, n).toString();
                String string2 = multipleObjectsBundle.data(n2, n).toString();
                return string.compareToIgnoreCase(string2);
            }
        });
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            List<?> list = multipleObjectsBundle.getColumn(i);
            ArrayList arrayList = new ArrayList(n2);
            for (int j = 0; j < n2; ++j) {
                arrayList.add(list.get(nArray[j]));
            }
            multipleObjectsBundle2.appendColumn(multipleObjectsBundle.meta(i), arrayList);
        }
        return multipleObjectsBundle2;
    }
}

