/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class HellingerHistogramNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    public static final HellingerHistogramNormalization<NumberVector> STATIC = new HellingerHistogramNormalization();

    @Override
    protected V filterSingleObject(V v) {
        int n;
        double[] dArray = new double[v.getDimensionality()];
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = v.doubleValue(n);
            dArray[n] = dArray[n] > 0.0 ? dArray[n] : -dArray[n];
            d += dArray[n];
        }
        if (d > 0.0) {
            for (n = 0; n < dArray.length; ++n) {
                if (!(dArray[n] > 0.0)) continue;
                dArray[n] = Math.sqrt(dArray[n] / d);
            }
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HellingerHistogramNormalization<NumberVector> makeInstance() {
            return STATIC;
        }
    }
}

