/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractNormalization;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AllOrNoneMustBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.EqualSizeGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseVarianceNormalization", "z", "de.lmu.ifi.dbs.elki.datasource.filter.AttributeWiseVarianceNormalization"})
public class AttributeWiseVarianceNormalization<V extends NumberVector>
extends AbstractNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseVarianceNormalization.class);
    private double[] mean;
    private double[] stddev;
    MeanVariance[] mvs = null;

    public AttributeWiseVarianceNormalization(double[] dArray, double[] dArray2) {
        this.mean = dArray;
        this.stddev = dArray2;
    }

    public AttributeWiseVarianceNormalization() {
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        return this.mean == null || this.stddev == null || this.mean.length == 0 || this.stddev.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        int n;
        if (this.mvs == null || this.mvs.length == 0) {
            n = v.getDimensionality();
            this.mvs = MeanVariance.newArray(n);
        }
        for (n = 0; n < v.getDimensionality(); ++n) {
            this.mvs[n].put(v.doubleValue(n));
        }
    }

    @Override
    protected void prepareComplete() {
        StringBuilder stringBuilder = LOG.isVerbose() ? new StringBuilder() : null;
        int n = this.mvs.length;
        this.mean = new double[n];
        this.stddev = new double[n];
        if (stringBuilder != null) {
            stringBuilder.append("Normalization parameters: ");
        }
        for (int i = 0; i < n; ++i) {
            this.mean[i] = this.mvs[i].getMean();
            this.stddev[i] = this.mvs[i].getSampleStddev();
            if (this.stddev[i] == 0.0 || Double.isNaN(this.stddev[i])) {
                this.stddev[i] = 1.0;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(" m: ").append(this.mean[i]).append(" v: ").append(this.stddev[i]);
        }
        this.mvs = null;
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
    }

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = this.normalize(i, v.doubleValue(i));
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        if (v.getDimensionality() != this.mean.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + v.getDimensionality() + " former dimensionality: " + this.mean.length);
        }
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = this.restore(i, v.doubleValue(i));
        }
        return this.factory.newNumberVector(dArray);
    }

    private double normalize(int n, double d) {
        n = this.mean.length == 1 ? 0 : n;
        return (d - this.mean[n]) / this.stddev[n];
    }

    private double restore(int n, double d) {
        n = this.mean.length == 1 ? 0 : n;
        return d * this.stddev[n] + this.mean[n];
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] dArray = linearEquationSystem.getCoefficents();
        double[] dArray2 = linearEquationSystem.getRHS();
        int[] nArray = linearEquationSystem.getRowPermutations();
        int[] nArray2 = linearEquationSystem.getColumnPermutations();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                double d = 0.0;
                for (int k = 0; k < dArray[0].length; ++k) {
                    d += this.mean[k] * dArray[nArray[j]][nArray2[k]] / this.stddev[k];
                    dArray[nArray[j]][nArray2[k]] = dArray[nArray[j]][nArray2[k]] / this.stddev[k];
                }
                dArray2[nArray[j]] = dArray2[nArray[j]] + d;
            }
        }
        return new LinearEquationSystem(dArray, dArray2, nArray, nArray2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization means: ").append(FormatUtil.format(this.mean));
        stringBuilder.append('\n');
        stringBuilder.append("normalization stddevs: ").append(FormatUtil.format(this.stddev));
        return stringBuilder.toString();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MEAN_ID = new OptionID("normalize.mean", "a comma separated concatenation of the mean values in each dimension that are mapped to 0. If no value is specified, the mean value of the attribute range in this dimension will be taken.");
        public static final OptionID STDDEV_ID = new OptionID("normalize.stddev", "a comma separated concatenation of the standard deviations in each dimension that are scaled to 1. If no value is specified, the standard deviation of the attribute range in this dimension will be taken.");
        private double[] mean = new double[0];
        private double[] stddev = new double[0];

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleListParameter doubleListParameter;
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter2 = (DoubleListParameter)new DoubleListParameter(MEAN_ID).setOptional(true);
            if (parameterization.grab(doubleListParameter2)) {
                this.mean = (double[])((double[])doubleListParameter2.getValue()).clone();
            }
            if (parameterization.grab(doubleListParameter = (DoubleListParameter)new DoubleListParameter(STDDEV_ID).setOptional(true))) {
                for (double d : this.stddev = (double[])((double[])doubleListParameter.getValue()).clone()) {
                    if (d != 0.0) continue;
                    parameterization.reportError(new WrongParameterValueException("Standard deviations must not be 0."));
                }
            }
            parameterization.checkConstraint(new AllOrNoneMustBeSetGlobalConstraint(doubleListParameter2, doubleListParameter));
            parameterization.checkConstraint(new EqualSizeGlobalConstraint(doubleListParameter2, doubleListParameter));
        }

        @Override
        protected AttributeWiseVarianceNormalization<V> makeInstance() {
            return new AttributeWiseVarianceNormalization(this.mean, this.stddev);
        }
    }
}

