/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractNormalization;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;

public class AttributeWiseMeanNormalization<V extends NumberVector>
extends AbstractNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMeanNormalization.class);
    private double[] mean = null;
    double[] sums = null;
    int c = 0;

    public AttributeWiseMeanNormalization(double[] dArray) {
        this.mean = dArray;
    }

    public AttributeWiseMeanNormalization() {
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        return this.mean == null || this.mean.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        int n;
        if (this.sums == null || this.sums.length == 0) {
            n = v.getDimensionality();
            this.sums = new double[n];
        }
        for (n = 0; n < v.getDimensionality(); ++n) {
            int n2 = n;
            this.sums[n2] = this.sums[n2] + v.doubleValue(n);
        }
        ++this.c;
    }

    @Override
    protected void prepareComplete() {
        StringBuilder stringBuilder = LOG.isVerbose() ? new StringBuilder() : null;
        int n = this.sums.length;
        this.mean = new double[n];
        if (stringBuilder != null) {
            stringBuilder.append("Normalization parameters: ");
        }
        for (int i = 0; i < n; ++i) {
            this.mean[i] = this.sums[i] / (double)this.c;
            if (stringBuilder == null) continue;
            stringBuilder.append(" m: ").append(this.mean[i]);
        }
        this.sums = null;
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
    }

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = this.normalize(i, v.doubleValue(i));
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        if (v.getDimensionality() != this.mean.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + v.getDimensionality() + " former dimensionality: " + this.mean.length);
        }
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = this.restore(i, v.doubleValue(i));
        }
        return this.factory.newNumberVector(dArray);
    }

    private double normalize(int n, double d) {
        n = this.mean.length == 1 ? 0 : n;
        return d / this.mean[n];
    }

    private double restore(int n, double d) {
        n = this.mean.length == 1 ? 0 : n;
        return d * this.mean[n];
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] dArray = linearEquationSystem.getCoefficents();
        double[] dArray2 = linearEquationSystem.getRHS();
        int[] nArray = linearEquationSystem.getRowPermutations();
        int[] nArray2 = linearEquationSystem.getColumnPermutations();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                double d = 0.0;
                for (int k = 0; k < dArray[0].length; ++k) {
                    d += dArray[nArray[j]][nArray2[k]] / this.mean[k];
                    dArray[nArray[j]][nArray2[k]] = dArray[nArray[j]][nArray2[k]] / this.mean[k];
                }
                dArray2[nArray[j]] = dArray2[nArray[j]] + d;
            }
        }
        return new LinearEquationSystem(dArray, dArray2, nArray, nArray2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization means: ").append(FormatUtil.format(this.mean));
        return stringBuilder.toString();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }
}

