/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.BetaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AttributeWiseBetaNormalization<V extends NumberVector>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseBetaNormalization.class);
    private List<DistributionEstimator<?>> estimators;
    private List<Distribution> dists;
    protected NumberVector.Factory<V> factory;
    protected double alpha = 0.01;

    public AttributeWiseBetaNormalization(List<DistributionEstimator<?>> list, double d) {
        this.estimators = list;
        this.alpha = d;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(simpleTypeInformation)) continue;
            List<?> list2 = list;
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
            this.factory = FilterUtil.guessFactory(vectorFieldTypeInformation);
            int n = vectorFieldTypeInformation.getDimensionality();
            this.dists = new ArrayList<Distribution>(n);
            double[] dArray = new double[list2.size()];
            Adapter adapter = new Adapter();
            for (int j = 0; j < n; ++j) {
                adapter.dim = j;
                if (this.estimators.size() == 1) {
                    this.dists.add((Distribution)this.estimators.get(0).estimate(list2, adapter));
                    continue;
                }
                Distribution distribution = null;
                double d = Double.POSITIVE_INFINITY;
                block4: for (DistributionEstimator<Double> distributionEstimator : this.estimators) {
                    try {
                        Object k = distributionEstimator.estimate(list2, adapter);
                        for (int i2 = 0; i2 < dArray.length; ++i2) {
                            dArray[i2] = k.cdf(((NumberVector)list2.get(i2)).doubleValue(j));
                            if (Double.isNaN(dArray[i2])) {
                                LOG.warning("Got NaN after fitting " + distributionEstimator.toString() + ": " + k.toString());
                                continue block4;
                            }
                            if (!Double.isInfinite(dArray[i2])) continue;
                            LOG.warning("Got infinite value after fitting " + distributionEstimator.toString() + ": " + k.toString());
                            continue block4;
                        }
                        Arrays.sort(dArray);
                        double d2 = KolmogorovSmirnovTest.simpleTest(dArray);
                        if (LOG.isVeryVerbose()) {
                            LOG.veryverbose("Estimator " + distributionEstimator.toString() + " (" + k.toString() + ") has maximum deviation " + d2 + " for dimension " + j);
                        }
                        if (distribution != null && !(d2 < d)) continue;
                        distribution = k;
                        d = d2;
                    }
                    catch (ArithmeticException arithmeticException) {
                        if (!LOG.isVeryVerbose()) continue;
                        LOG.veryverbose("Fitting distribution " + distributionEstimator + " failed: " + arithmeticException.getMessage());
                    }
                }
                if (LOG.isVerbose()) {
                    LOG.verbose("Best fit for dimension " + j + ": " + distribution.toString());
                }
                this.dists.add(distribution);
            }
            double d = Math.pow(this.alpha, -1.0 / Math.sqrt(n));
            BetaDistribution betaDistribution = new BetaDistribution(d, d);
            double[] dArray2 = new double[n];
            for (int j = 0; j < multipleObjectsBundle.dataLength(); ++j) {
                NumberVector numberVector = (NumberVector)list2.get(j);
                for (int k = 0; k < n; ++k) {
                    dArray2[k] = betaDistribution.quantile(this.dists.get(k).cdf(numberVector.doubleValue(k)));
                }
                list2.set(j, this.factory.newNumberVector(dArray2));
            }
        }
        return multipleObjectsBundle;
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization distributions: ");
        boolean bl = true;
        for (DistributionEstimator<?> distributionEstimator : this.estimators) {
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            stringBuilder.append(distributionEstimator.getClass().getSimpleName());
        }
        return stringBuilder.toString();
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DISTRIBUTIONS_ID = new OptionID("betanormalize.distributions", "A list of the distribution estimators to try.");
        public static final OptionID ALPHA_ID = new OptionID("betanormalize.alpha", "Alpha parameter to control the shape of the output distribution.");
        private List<DistributionEstimator<?>> estimators;
        private double alpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(DISTRIBUTIONS_ID, DistributionEstimator.class);
            ArrayList<Class<BestFitEstimator>> arrayList = new ArrayList<Class<BestFitEstimator>>(1);
            arrayList.add(BestFitEstimator.class);
            objectListParameter.setDefaultValue(arrayList);
            if (parameterization.grab(objectListParameter)) {
                this.estimators = objectListParameter.instantiateClasses(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(ALPHA_ID, 0.1))) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected AttributeWiseBetaNormalization<V> makeInstance() {
            return new AttributeWiseBetaNormalization(this.estimators, this.alpha);
        }
    }

    private static class Adapter
    implements NumberArrayAdapter<Double, List<? extends NumberVector>> {
        int dim;

        private Adapter() {
        }

        @Override
        public int size(List<? extends NumberVector> list) {
            return list.size();
        }

        @Override
        public Double get(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return this.getDouble(list, n);
        }

        @Override
        public double getDouble(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).doubleValue(this.dim);
        }

        @Override
        public float getFloat(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).floatValue(this.dim);
        }

        @Override
        public int getInteger(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).intValue(this.dim);
        }

        @Override
        public short getShort(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).shortValue(this.dim);
        }

        @Override
        public long getLong(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).longValue(this.dim);
        }

        @Override
        public byte getByte(List<? extends NumberVector> list, int n) throws IndexOutOfBoundsException {
            return list.get(n).byteValue(this.dim);
        }
    }
}

