/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class ExternalIDJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ExternalIDJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public ExternalIDJoinDatabaseConnection(List<ObjectFilter> list, List<DatabaseConnection> list2) {
        super(list);
        this.sources = list2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        int n;
        int n2;
        DatabaseConnection databaseConnection2;
        ArrayList<MultipleObjectsBundle> arrayList = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection2 : this.sources) {
            arrayList.add(databaseConnection2.loadData());
        }
        MultipleObjectsBundle multipleObjectsBundle = (MultipleObjectsBundle)arrayList.get(0);
        databaseConnection2 = new TObjectIntHashMap(multipleObjectsBundle.dataLength(), 0.5f, -1);
        int n3 = -1;
        for (n2 = 0; n2 < multipleObjectsBundle.metaLength(); ++n2) {
            if (!TypeUtil.EXTERNALID.isAssignableFromType(multipleObjectsBundle.meta(n2))) continue;
            n3 = n2;
            break;
        }
        if ((n = n3) == -1) {
            throw new AbortException("No external ID column found in primary source.");
        }
        for (n3 = 0; n3 < multipleObjectsBundle.dataLength(); ++n3) {
            ExternalID externalID = (ExternalID)multipleObjectsBundle.data(n3, n);
            if (externalID == null) {
                LOG.debug("Object without ID encountered.");
                continue;
            }
            int n4 = databaseConnection2.put(externalID, n3);
            if (n4 == -1) continue;
            LOG.debug("Duplicate id encountered: " + externalID + " in rows " + n4 + " and " + n3);
        }
        for (n = 1; n < this.sources.size(); ++n) {
            int n5;
            Object object;
            int n6;
            MultipleObjectsBundle multipleObjectsBundle2 = (MultipleObjectsBundle)arrayList.get(n);
            int n7 = -1;
            for (n6 = 0; n6 < multipleObjectsBundle2.metaLength(); ++n6) {
                if (!TypeUtil.EXTERNALID.isAssignableFromType(multipleObjectsBundle2.meta(n6))) continue;
                n7 = n6;
                break;
            }
            if ((n2 = n7) == -1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (n6 = 0; n6 < multipleObjectsBundle2.metaLength(); ++n6) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(multipleObjectsBundle2.meta(n6));
                }
                throw new AbortException("No external ID column found in source " + (n + 1) + " to join with. Got: " + stringBuilder.toString());
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>(multipleObjectsBundle2.metaLength());
            for (n6 = 0; n6 < multipleObjectsBundle2.metaLength(); ++n6) {
                if (n6 == n2) {
                    arrayList2.add(null);
                    continue;
                }
                object = new ArrayList(multipleObjectsBundle.dataLength());
                for (n5 = 0; n5 < multipleObjectsBundle.dataLength(); ++n5) {
                    ((ArrayList)object).add(null);
                }
                multipleObjectsBundle.appendColumn(multipleObjectsBundle2.meta(n6), (List<?>)object);
                arrayList2.add(object);
            }
            for (n6 = 0; n6 < multipleObjectsBundle2.dataLength(); ++n6) {
                object = (ExternalID)multipleObjectsBundle2.data(n6, n2);
                if (object == null) {
                    LOG.warning("Object without label encountered.");
                    continue;
                }
                n5 = databaseConnection2.get(object);
                if (n5 == -1) {
                    LOG.debug("ID not found for join: " + object + " in row " + n6);
                    continue;
                }
                for (int i = 0; i < multipleObjectsBundle2.metaLength(); ++i) {
                    if (i == n2) continue;
                    List list = (List)arrayList2.get(i);
                    assert (list != null);
                    list.set(n5, multipleObjectsBundle2.data(n6, i));
                }
            }
        }
        block10: for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            for (n3 = 0; n3 < multipleObjectsBundle.metaLength(); ++n3) {
                if (multipleObjectsBundle.data(n, n3) != null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    if (multipleObjectsBundle.data(n, i) == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    stringBuilder.append(multipleObjectsBundle.data(n, i));
                }
                LOG.warning("null value in joined data, row " + n + " column " + n3 + FormatUtil.NEWLINE + "[" + stringBuilder.toString() + "]");
                continue block10;
            }
        }
        return multipleObjectsBundle;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            super.configFilters(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (parameterization.grab(objectListParameter)) {
                this.sources = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected ExternalIDJoinDatabaseConnection makeInstance() {
            return new ExternalIDJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

