/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanPrimitiveDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;

public class LinearScanEuclideanDistanceRangeQuery<O extends NumberVector>
extends LinearScanPrimitiveDistanceRangeQuery<O> {
    private static final SquaredEuclideanDistanceFunction SQUARED = SquaredEuclideanDistanceFunction.STATIC;

    public LinearScanEuclideanDistanceRangeQuery(PrimitiveDistanceQuery<O> primitiveDistanceQuery) {
        super(primitiveDistanceQuery);
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef dBIDRef, double d) {
        NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), numberVector, d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O o, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), o, d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public void getRangeForDBID(DBIDRef dBIDRef, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), (NumberVector)this.relation.get(dBIDRef), d, modifiableDoubleDBIDList);
    }

    @Override
    public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), o, d, modifiableDoubleDBIDList);
    }

    private void linearScan(Relation<? extends O> relation, DBIDIter dBIDIter, O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        double d2 = d * 1.0000001;
        double d3 = d2 * d2;
        while (dBIDIter.valid()) {
            double d4;
            double d5 = SQUARED.distance((NumberVector)o, (NumberVector)relation.get(dBIDIter));
            if (d5 <= d3 && (d4 = Math.sqrt(d5)) <= d) {
                modifiableDoubleDBIDList.add(d4, dBIDIter);
            }
            dBIDIter.advance();
        }
    }
}

