/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import java.util.ArrayList;
import java.util.List;

public class LinearScanDistanceKNNQuery<O>
extends AbstractDistanceKNNQuery<O>
implements LinearScanQuery {
    public LinearScanDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
        KNNHeap kNNHeap = DBIDUtil.newHeap(n);
        double d = Double.POSITIVE_INFINITY;
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(dBIDRef, (DBIDRef)dBIDIter);
            if (d2 <= d) {
                d = kNNHeap.insert(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
        return kNNHeap.toKNNList();
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        KNNHeap kNNHeap = DBIDUtil.newHeap(n);
        double d = Double.POSITIVE_INFINITY;
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(o, dBIDIter);
            if (d2 <= d) {
                d = kNNHeap.insert(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
        return kNNHeap.toKNNList();
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        int n2 = arrayDBIDs.size();
        ArrayList<KNNHeap> arrayList = new ArrayList<KNNHeap>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(DBIDUtil.newHeap(n));
        }
        this.linearScanBatchKNN(arrayDBIDs, arrayList);
        ArrayList<KNNList> arrayList2 = new ArrayList<KNNList>(n2);
        for (KNNHeap kNNHeap : arrayList) {
            arrayList2.add(kNNHeap.toKNNList());
        }
        return arrayList2;
    }

    private void linearScanBatchKNN(ArrayDBIDs arrayDBIDs, List<KNNHeap> list) {
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            int n = 0;
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                KNNHeap kNNHeap = list.get(n);
                kNNHeap.insert(this.distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDIter), dBIDIter);
                ++n;
                dBIDArrayIter.advance();
            }
            dBIDIter.advance();
        }
    }
}

