/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.distance;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DBIDDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDRangeDistanceFunction;

public class DBIDRangeDistanceQuery
extends DBIDDistanceQuery {
    protected final DBIDRangeDistanceFunction distanceFunction;
    protected final DBIDRange range;

    public DBIDRangeDistanceQuery(Relation<DBID> relation, DBIDRangeDistanceFunction dBIDRangeDistanceFunction) {
        super(relation, dBIDRangeDistanceFunction);
        this.range = DBIDUtil.assertRange(relation.getDBIDs());
        dBIDRangeDistanceFunction.checkRange(this.range);
        this.distanceFunction = dBIDRangeDistanceFunction;
    }

    @Override
    public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return this.distanceFunction.distance(this.range.getOffset(dBIDRef), this.range.getOffset(dBIDRef2));
    }

    @Override
    public DBIDDistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }
}

