/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.integer.SimpleDBIDFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import java.util.ArrayList;
import java.util.BitSet;

public class ReusingDBIDFactory
extends SimpleDBIDFactory {
    private static final Logging LOG = Logging.getLogger(ReusingDBIDFactory.class);
    BitSet dynamicUsed = new BitSet();
    int dynamicStart = 0;
    ArrayList<IntegerDBIDRange> returnedAllocations = new ArrayList();

    @Override
    public synchronized DBID generateSingleDBID() {
        this.dynamicStart = this.dynamicUsed.nextClearBit(this.dynamicStart);
        this.dynamicUsed.set(this.dynamicStart);
        return DBIDFactory.FACTORY.importInteger(-(this.dynamicStart + 1));
    }

    @Override
    public synchronized void deallocateSingleDBID(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        if (n >= 0) {
            LOG.warning("Single DBID returned is from a range allocation!");
            return;
        }
        int n2 = -n - 1;
        this.dynamicUsed.clear(n2);
        this.dynamicStart = Math.min(this.dynamicStart, n2);
    }

    @Override
    public synchronized DBIDRange generateStaticDBIDRange(int n) {
        IntegerDBIDRange integerDBIDRange;
        int n2;
        for (n2 = 0; n2 < this.returnedAllocations.size(); ++n2) {
            integerDBIDRange = this.returnedAllocations.get(n2);
            if (integerDBIDRange.size() != n) continue;
            this.returnedAllocations.remove(n2);
            return integerDBIDRange;
        }
        for (n2 = 0; n2 < this.returnedAllocations.size(); ++n2) {
            integerDBIDRange = this.returnedAllocations.get(n2);
            if (integerDBIDRange.size() <= n) continue;
            IntegerDBIDRange integerDBIDRange2 = new IntegerDBIDRange(integerDBIDRange.start, n);
            integerDBIDRange = new IntegerDBIDRange(integerDBIDRange.start + n, integerDBIDRange.size() - n);
            this.returnedAllocations.set(n2, integerDBIDRange);
            return integerDBIDRange2;
        }
        return super.generateStaticDBIDRange(n);
    }

    @Override
    public synchronized void deallocateDBIDRange(DBIDRange dBIDRange) {
        this.returnedAllocations.add((IntegerDBIDRange)dBIDRange);
    }
}

