/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;

class IntegerDBIDPair
implements DBIDPair,
IntegerDBIDs {
    public int first;
    public int second;

    protected IntegerDBIDPair(int n, int n2) {
        this.first = n;
        this.second = n2;
    }

    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }

    @Override
    @Deprecated
    public final IntegerDBID getFirst() {
        return new IntegerDBID(this.first);
    }

    @Override
    @Deprecated
    public final IntegerDBID getSecond() {
        return new IntegerDBID(this.second);
    }

    @Override
    @Deprecated
    public DBID get(int n) {
        if (n < 0 || n > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n == 0 ? this.getFirst() : this.getSecond();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntegerDBIDPair)) {
            return false;
        }
        IntegerDBIDPair integerDBIDPair = (IntegerDBIDPair)object;
        return this.first == integerDBIDPair.first && this.second == integerDBIDPair.second;
    }

    public final int hashCode() {
        long l = 1L;
        l = 2654435761L * l + (long)this.first;
        l = 2654435761L * l + (long)this.second;
        return (int)l;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        return n == this.first || n == this.second;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (n == 0) {
            if (dBIDVar instanceof IntegerDBIDVar) {
                ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.first);
                return dBIDVar;
            }
            dBIDVar.set(new IntegerDBID(this.first));
            return dBIDVar;
        }
        if (n == 1) {
            if (dBIDVar instanceof IntegerDBIDVar) {
                ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.second);
                return dBIDVar;
            }
            dBIDVar.set(new IntegerDBID(this.second));
            return dBIDVar;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public ArrayDBIDs slice(int n, int n2) {
        return new Slice(n, n2);
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        return n == this.first ? 0 : (n == this.second ? 1 : (n < this.first ? -1 : (n < this.second ? -2 : -3)));
    }

    @Override
    public IntegerDBIDArrayIter iter() {
        return new Itr(this.first, this.second);
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef dBIDRef) {
            int n = dBIDRef.internalGetIndex();
            if (this.begin == 0 && this.end > 0 && IntegerDBIDPair.this.first == n) {
                return true;
            }
            return this.begin <= 1 && this.end > 1 && IntegerDBIDPair.this.second == n;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int n) {
            return IntegerDBIDPair.this.get(this.begin + n);
        }

        @Override
        public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
            return IntegerDBIDPair.this.assignVar(this.begin + n, dBIDVar);
        }

        @Override
        public int binarySearch(DBIDRef dBIDRef) {
            return IntegerDBIDPair.this.binarySearch(dBIDRef) - this.begin;
        }

        @Override
        public IntegerDBIDArrayIter iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int n, int n2) {
            return new Slice(n + n, n + n2);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                if (this.pos < 0 || this.pos > 1) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.pos == 0 ? IntegerDBIDPair.this.first : IntegerDBIDPair.this.second;
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int n) {
                this.pos += n;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int n) {
                this.pos = Slice.this.begin + n;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    private static class Itr
    implements IntegerDBIDArrayIter {
        int first;
        int second;
        int pos;

        public Itr(int n, int n2) {
            this.first = n;
            this.second = n2;
            this.pos = 0;
        }

        @Override
        public boolean valid() {
            return this.pos < 2;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int internalGetIndex() {
            return this.pos == 0 ? this.first : this.second;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public DBIDArrayIter advance(int n) {
            return null;
        }

        @Override
        public DBIDArrayIter retract() {
            --this.pos;
            return this;
        }

        @Override
        public DBIDArrayIter seek(int n) {
            this.pos = n;
            return this;
        }
    }
}

