/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRef;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;
import java.nio.ByteBuffer;

final class IntegerDBID
implements DBID,
IntegerDBIDRef {
    protected final int id;
    public static final ByteBufferSerializer<DBID> DYNAMIC_SERIALIZER = new DynamicSerializer();
    public static final FixedSizeByteBufferSerializer<DBID> STATIC_SERIALIZER = new StaticSerializer();

    protected IntegerDBID(int n) {
        this.id = n;
    }

    protected IntegerDBID(Integer n) {
        this.id = n;
    }

    @Override
    public int internalGetIndex() {
        return this.id;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return this.id != Integer.MIN_VALUE ? Integer.toString(this.id) : "null";
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @Deprecated
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntegerDBID)) {
            if (object instanceof DBIDRef) {
                LoggingUtil.warning("Programming error: DBID.equals(DBIDRef) is not well-defined. Use DBIDUtil.equal() instead!", new Throwable());
            }
            return false;
        }
        IntegerDBID integerDBID = (IntegerDBID)object;
        return this.id == integerDBID.id;
    }

    @Override
    public int compareTo(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        return this.id < n ? -1 : (this.id == n ? 0 : 1);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public DBID get(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        dBIDVar.set(this);
        return dBIDVar;
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        return dBIDRef.internalGetIndex() == this.id;
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        return n == this.id ? 0 : (n < this.id ? -1 : -2);
    }

    @Override
    public ArrayDBIDs slice(int n, int n2) {
        if (n == 0 && n2 == 1) {
            return this;
        }
        return DBIDUtil.EMPTYDBIDS;
    }

    public static class StaticSerializer
    implements FixedSizeByteBufferSerializer<DBID> {
        @Override
        public DBID fromByteBuffer(ByteBuffer byteBuffer) throws UnsupportedOperationException {
            return new IntegerDBID(byteBuffer.getInt());
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, DBID dBID) throws UnsupportedOperationException {
            byteBuffer.putInt(((IntegerDBID)dBID).id);
        }

        @Override
        public int getByteSize(DBID dBID) throws UnsupportedOperationException {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static class DynamicSerializer
    implements ByteBufferSerializer<DBID> {
        @Override
        public DBID fromByteBuffer(ByteBuffer byteBuffer) throws UnsupportedOperationException {
            return new IntegerDBID(ByteArrayUtil.readSignedVarint(byteBuffer));
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, DBID dBID) throws UnsupportedOperationException {
            ByteArrayUtil.writeSignedVarint(byteBuffer, ((IntegerDBID)dBID).id);
        }

        @Override
        public int getByteSize(DBID dBID) throws UnsupportedOperationException {
            return ByteArrayUtil.getSignedVarintSize(((IntegerDBID)dBID).id);
        }
    }

    protected class Itr
    implements DBIDArrayIter,
    IntegerDBIDRef {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return IntegerDBID.this.id;
        }

        @Override
        public boolean valid() {
            return this.pos == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(object);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

