/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;

class DoubleIntegerDBIDList
implements ModifiableDoubleDBIDList,
IntegerDBIDs {
    private static final int INITIAL_SIZE = 21;
    int size;
    double[] dists;
    int[] ids;
    private static final double[] EMPTY_DISTS = new double[0];
    private static final int[] EMPTY_IDS = new int[0];

    protected DoubleIntegerDBIDList() {
        this.dists = EMPTY_DISTS;
        this.ids = EMPTY_IDS;
    }

    protected DoubleIntegerDBIDList(int n) {
        this.dists = new double[n];
        this.ids = new int[n];
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (n != this.ids[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DoubleIntegerDBIDPair get(int n) {
        return new DoubleIntegerDBIDPair(this.dists[n], this.ids[n]);
    }

    protected void addInternal(double d, int n) {
        if (this.size == this.dists.length) {
            this.grow();
        }
        this.dists[this.size] = d;
        this.ids[this.size] = n;
        ++this.size;
    }

    protected void grow() {
        if (this.dists == EMPTY_DISTS) {
            this.dists = new double[21];
            this.ids = new int[21];
            return;
        }
        int n = this.dists.length;
        int n2 = n + (n >> 1);
        double[] dArray = this.dists;
        this.dists = new double[n2];
        System.arraycopy(dArray, 0, this.dists, 0, dArray.length);
        int[] nArray = this.ids;
        this.ids = new int[n2];
        System.arraycopy(nArray, 0, this.ids, 0, nArray.length);
    }

    @Override
    public void add(double d, DBIDRef dBIDRef) {
        this.addInternal(d, dBIDRef.internalGetIndex());
    }

    @Override
    public void add(DoubleDBIDPair doubleDBIDPair) {
        this.addInternal(doubleDBIDPair.doubleValue(), doubleDBIDPair.internalGetIndex());
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public void sort() {
        DoubleIntegerArrayQuickSort.sort(this.dists, this.ids, 0, this.size);
    }

    protected void reverse() {
        int n = 0;
        for (int i = this.size - 1; n < i; ++n, --i) {
            double d = this.dists[i];
            this.dists[i] = this.dists[n];
            this.dists[n] = d;
            int n2 = this.ids[i];
            this.ids[i] = this.ids[n];
            this.ids[n] = n2;
        }
    }

    @Override
    public void remove(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < --this.size) {
            System.arraycopy(this.dists, n + 1, this.dists, n, this.size - n);
            System.arraycopy(this.ids, n + 1, this.ids, n, this.size - n);
        }
    }

    @Override
    public void removeSwap(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (--this.size > 0) {
            this.dists[n] = this.dists[this.size];
            this.ids[n] = this.ids[this.size];
        }
    }

    @Override
    public void swap(int n, int n2) {
        double d = this.dists[n];
        this.dists[n] = this.dists[n2];
        this.dists[n2] = d;
        int n3 = this.ids[n];
        this.ids[n] = this.ids[n2];
        this.ids[n2] = n3;
    }

    public void truncate(int n) {
        if (n < this.size) {
            double[] dArray = this.dists;
            this.dists = new double[n];
            System.arraycopy(dArray, 0, this.dists, 0, n);
            int[] nArray = this.ids;
            this.ids = new int[n];
            System.arraycopy(nArray, 0, this.ids, 0, n);
            this.size = n;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DoubleDBIDList[");
        Itr itr = this.iter();
        while (itr.valid()) {
            stringBuilder.append(itr.doubleValue()).append(':').append(itr.internalGetIndex());
            itr.advance();
            if (!itr.valid()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private class Itr
    implements DoubleIntegerDBIDListMIter {
        int pos = 0;

        private Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerDBIDList.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int internalGetIndex() {
            return DoubleIntegerDBIDList.this.ids[this.pos];
        }

        @Override
        public double doubleValue() {
            return DoubleIntegerDBIDList.this.dists[this.pos];
        }

        @Override
        public void remove() {
            DoubleIntegerDBIDList.this.remove(this.pos);
        }

        @Override
        public void setDBID(DBIDRef dBIDRef) {
            DoubleIntegerDBIDList.this.ids[this.pos] = dBIDRef.internalGetIndex();
        }

        @Override
        public void setDouble(double d) {
            DoubleIntegerDBIDList.this.dists[this.pos] = d;
        }

        @Override
        public DoubleDBIDPair getPair() {
            return new DoubleIntegerDBIDPair(DoubleIntegerDBIDList.this.dists[this.pos], DoubleIntegerDBIDList.this.ids[this.pos]);
        }

        public String toString() {
            return this.doubleValue() + ":" + this.internalGetIndex() + "@" + this.pos;
        }
    }
}

