/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.generic;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;

public class KNNSubList
implements KNNList {
    private final int k;
    private final int size;
    private final KNNList inner;

    public KNNSubList(KNNList kNNList, int n) {
        this.inner = kNNList;
        this.k = n;
        if (n < kNNList.getK()) {
            DoubleDBIDPair doubleDBIDPair = kNNList.get(n);
            int n2 = n;
            while (n2 + 1 < kNNList.size() && !(doubleDBIDPair.doubleValue() < kNNList.get(n2 + 1).doubleValue())) {
                ++n2;
            }
            this.size = n2;
        } else {
            this.size = kNNList.size();
        }
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public DoubleDBIDPair get(int n) {
        assert (n < this.size) : "Access beyond design size of list.";
        return this.inner.get(n);
    }

    @Override
    public double getKNNDistance() {
        return this.inner.get(this.k).doubleValue();
    }

    @Override
    public DoubleDBIDListIter iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        DoubleDBIDListIter doubleDBIDListIter = this.iter();
        while (doubleDBIDListIter.valid()) {
            if (DBIDUtil.equal(doubleDBIDListIter, dBIDRef)) {
                return true;
            }
            doubleDBIDListIter.advance();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private class Itr
    implements DoubleDBIDListIter {
        private int pos = 0;

        private Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < KNNSubList.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double doubleValue() {
            return KNNSubList.this.inner.get(this.pos).doubleValue();
        }

        @Override
        public DoubleDBIDPair getPair() {
            return KNNSubList.this.inner.get(this.pos);
        }

        @Override
        public int internalGetIndex() {
            return KNNSubList.this.inner.get(this.pos).internalGetIndex();
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }
    }
}

