/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;

public class MapIntegerDBIDDBIDStore
implements WritableDBIDDataStore {
    private TIntIntMap map;

    public MapIntegerDBIDDBIDStore(int n) {
        this.map = new TIntIntHashMap(n, 0.5f, Integer.MIN_VALUE, DBIDUtil.asInteger(DBIDUtil.invalid()));
    }

    @Override
    @Deprecated
    public DBID get(DBIDRef dBIDRef) {
        return DBIDUtil.importInteger(this.map.get(DBIDUtil.asInteger(dBIDRef)));
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }

    @Override
    @Deprecated
    public DBID put(DBIDRef dBIDRef, DBID dBID) {
        return DBIDUtil.importInteger(this.map.put(DBIDUtil.asInteger(dBIDRef), DBIDUtil.asInteger(dBID)));
    }

    @Override
    public void put(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        this.map.put(DBIDUtil.asInteger(dBIDRef), DBIDUtil.asInteger(dBIDRef2));
    }

    @Override
    public void putDBID(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        this.map.put(DBIDUtil.asInteger(dBIDRef), DBIDUtil.asInteger(dBIDRef2));
    }

    @Override
    public DBIDVar assignVar(DBIDRef dBIDRef, DBIDVar dBIDVar) {
        int n = this.map.get(DBIDUtil.asInteger(dBIDRef));
        DBIDFactory.FACTORY.assignVar(dBIDVar, n);
        return dBIDVar;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.map.remove(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

