/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;

public class ArrayDBIDStore
implements WritableDBIDDataStore {
    private ArrayModifiableDBIDs data;
    private DataStoreIDMap idmap;

    public ArrayDBIDStore(int n, DataStoreIDMap dataStoreIDMap) {
        this.data = DBIDUtil.newArray(n);
        DBIDRef dBIDRef = DBIDUtil.invalid();
        for (int i = 0; i < n; ++i) {
            this.data.add(dBIDRef);
        }
        this.idmap = dataStoreIDMap;
    }

    @Override
    @Deprecated
    public DBID get(DBIDRef dBIDRef) {
        return this.data.get(this.idmap.mapDBIDToOffset(dBIDRef));
    }

    @Override
    public DBIDVar assignVar(DBIDRef dBIDRef, DBIDVar dBIDVar) {
        this.data.assignVar(this.idmap.mapDBIDToOffset(dBIDRef), dBIDVar);
        return dBIDVar;
    }

    @Override
    @Deprecated
    public DBID put(DBIDRef dBIDRef, DBID dBID) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        DBID dBID2 = this.data.get(n);
        this.data.set(n, dBID);
        return dBID2;
    }

    @Override
    public void putDBID(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        this.data.set(n, dBIDRef2);
    }

    @Override
    public void put(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        this.data.set(n, dBIDRef2);
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void clear() {
        DBIDRef dBIDRef = DBIDUtil.invalid();
        int n = this.data.size();
        this.data.clear();
        for (int i = 0; i < n; ++i) {
            this.data.add(dBIDRef);
        }
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.put(dBIDRef, DBIDUtil.invalid());
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

