/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.uncertain.UniformContinuousUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.Random;

public class UniformUncertainifier
implements Uncertainifier<UniformContinuousUncertainObject> {
    double minDev;
    double maxDev;
    boolean symmetric;

    public UniformUncertainifier(double d, double d2, boolean bl) {
        this.minDev = d;
        this.maxDev = d2;
    }

    @Override
    public <A> UniformContinuousUncertainObject newFeatureVector(Random random, A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        if (this.symmetric) {
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                double d2 = random.nextDouble() * (this.maxDev - this.minDev) + this.minDev;
                dArray[i] = d - d2;
                dArray2[i] = d + d2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                dArray[i] = d - (random.nextDouble() * (this.maxDev - this.minDev) + this.minDev);
                dArray2[i] = d + (random.nextDouble() * (this.maxDev - this.minDev) + this.minDev);
            }
        }
        return new UniformContinuousUncertainObject(new HyperBoundingBox(dArray, dArray2));
    }

    @Override
    public FeatureVector.Factory<UniformContinuousUncertainObject, ?> getFactory() {
        return UniformContinuousUncertainObject.FACTORY;
    }

    public static final class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DEV_MIN_ID = new OptionID("uo.uncertainty.min", "Minimum deviation of uncertain bounding box.");
        public static final OptionID DEV_MAX_ID = new OptionID("uo.uncertainty.max", "Maximum deviation of uncertain bounding box.");
        protected double minDev;
        protected double maxDev;
        protected boolean symmetric;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(DEV_MIN_ID, 0.0);
            if (parameterization.grab(doubleParameter2)) {
                this.minDev = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(DEV_MAX_ID))) {
                this.maxDev = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(Uncertainifier.SYMMETRIC_ID))) {
                this.symmetric = flag.isTrue();
            }
        }

        @Override
        protected UniformUncertainifier makeInstance() {
            return new UniformUncertainifier(this.minDev, this.maxDev, this.symmetric);
        }
    }
}

