/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import java.util.Random;

public abstract class AbstractUncertainObject
implements UncertainObject {
    public static final int DEFAULT_TRY_LIMIT = 1000;
    protected SpatialComparable bounds;

    protected static HyperBoundingBox computeBounds(NumberVector[] numberVectorArray) {
        int n;
        assert (numberVectorArray.length > 0) : "Cannot compute bounding box of empty set.";
        int n2 = numberVectorArray[0].getDimensionality();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        NumberVector numberVector = numberVectorArray[0];
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray2[n] = numberVector.doubleValue(n);
        }
        for (n = 1; n < numberVectorArray.length; ++n) {
            NumberVector numberVector2 = numberVectorArray[n];
            for (int i = 0; i < n2; ++i) {
                double d = numberVector2.doubleValue(i);
                dArray[i] = d < dArray[i] ? d : dArray[i];
                dArray2[i] = d > dArray2[i] ? d : dArray2[i];
            }
        }
        return new HyperBoundingBox(dArray, dArray2);
    }

    @Override
    public abstract DoubleVector drawSample(Random var1);

    @Override
    public int getDimensionality() {
        return this.bounds.getDimensionality();
    }

    @Override
    public double getMin(int n) {
        return this.bounds.getMin(n);
    }

    @Override
    public double getMax(int n) {
        return this.bounds.getMax(n);
    }

    @Override
    public Double getValue(int n) {
        return (this.bounds.getMax(n) + this.bounds.getMin(n)) * 0.5;
    }

    @Override
    public abstract DoubleVector getCenterOfMass();
}

