/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class PolygonsObject
implements SpatialComparable {
    public static final PolygonsObject PROTOTYPE = new PolygonsObject(null);
    private Collection<Polygon> polygons;

    public PolygonsObject(Collection<Polygon> collection) {
        this.polygons = collection;
        if (this.polygons == null) {
            this.polygons = Collections.emptyList();
        }
    }

    public Collection<Polygon> getPolygons() {
        return Collections.unmodifiableCollection(this.polygons);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendToBuffer(stringBuilder);
        return stringBuilder.toString();
    }

    public void appendToBuffer(StringBuilder stringBuilder) {
        Iterator<Polygon> iterator = this.polygons.iterator();
        while (iterator.hasNext()) {
            Polygon polygon = iterator.next();
            polygon.appendToBuffer(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" -- ");
        }
    }

    @Override
    public int getDimensionality() {
        assert (this.polygons.size() > 0);
        return this.polygons.iterator().next().getDimensionality();
    }

    @Override
    public double getMin(int n) {
        double d = Double.MAX_VALUE;
        for (Polygon polygon : this.polygons) {
            d = Math.min(d, polygon.getMin(n));
        }
        return d;
    }

    @Override
    public double getMax(int n) {
        double d = Double.MIN_VALUE;
        for (Polygon polygon : this.polygons) {
            d = Math.max(d, polygon.getMin(n));
        }
        return d;
    }
}

