/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AchlioptasRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class RandomProjection<V extends NumberVector>
implements Projection<V, V> {
    private static final Logging LOG = Logging.getLogger(RandomProjection.class);
    private NumberVector.Factory<V> factory = null;
    private int dimensionality;
    private RandomProjectionFamily.Projection projection = null;
    private RandomProjectionFamily family;

    public RandomProjection(int n, RandomProjectionFamily randomProjectionFamily) {
        this.dimensionality = n;
        this.family = randomProjectionFamily;
    }

    @Override
    public void initialize(SimpleTypeInformation<V> simpleTypeInformation) {
        VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
        this.factory = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
        int n = vectorFieldTypeInformation.getDimensionality();
        this.projection = this.family.generateProjection(n, this.dimensionality);
        if (LOG.isDebugging()) {
            LOG.debug(this.projection.toString());
        }
    }

    @Override
    public V project(V v) {
        return this.factory.newNumberVector(this.projection.project((NumberVector)v));
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, this.dimensionality);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FAMILY_ID = new OptionID("randomproj.family", "Projection family to use.");
        public static final OptionID DIMENSIONALITY_ID = new OptionID("randomproj.dimensionality", "Amount of dimensions to project to.");
        private int dimensionality;
        private RandomProjectionFamily family;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(FAMILY_ID, RandomProjectionFamily.class);
            objectParameter.setDefaultValue(AchlioptasRandomProjectionFamily.class);
            if (parameterization.grab(objectParameter)) {
                this.family = (RandomProjectionFamily)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(DIMENSIONALITY_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.dimensionality = intParameter.intValue();
            }
        }

        @Override
        protected RandomProjection<NumberVector> makeInstance() {
            return new RandomProjection<NumberVector>(this.dimensionality, this.family);
        }
    }
}

