/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.Comparator;
import java.util.Random;

public final class VectorUtil {
    private VectorUtil() {
    }

    public static <V extends NumberVector> V randomVector(NumberVector.Factory<V> factory, int n, Random random) {
        return factory.newNumberVector(MathUtil.randomDoubleArray(n, random));
    }

    public static <V extends NumberVector> V randomVector(NumberVector.Factory<V> factory, int n) {
        return VectorUtil.randomVector(factory, n, new Random());
    }

    public static double angleSparse(SparseNumberVector sparseNumberVector, SparseNumberVector sparseNumberVector2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = sparseNumberVector.iter();
        int n2 = sparseNumberVector2.iter();
        while (sparseNumberVector.iterValid(n) && sparseNumberVector2.iterValid(n2)) {
            double d4;
            int n3;
            int n4 = sparseNumberVector.iterDim(n);
            if (n4 < (n3 = sparseNumberVector2.iterDim(n2))) {
                d4 = sparseNumberVector.iterDoubleValue(n);
                d += d4 * d4;
                n = sparseNumberVector.iterAdvance(n);
                continue;
            }
            if (n3 < n4) {
                d4 = sparseNumberVector2.iterDoubleValue(n2);
                d2 += d4 * d4;
                n2 = sparseNumberVector2.iterAdvance(n2);
                continue;
            }
            d4 = sparseNumberVector.iterDoubleValue(n);
            double d5 = sparseNumberVector2.iterDoubleValue(n2);
            d += d4 * d4;
            d2 += d5 * d5;
            d3 += d4 * d5;
            n = sparseNumberVector.iterAdvance(n);
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        while (sparseNumberVector.iterValid(n)) {
            double d6 = sparseNumberVector.iterDoubleValue(n);
            d += d6 * d6;
            n = sparseNumberVector.iterAdvance(n);
        }
        while (sparseNumberVector2.iterValid(n2)) {
            double d7 = sparseNumberVector2.iterDoubleValue(n2);
            d2 += d7 * d7;
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        if (d == 0.0 || d2 == 0.0) {
            return 1.0;
        }
        double d8 = Math.sqrt(d3 / d * (d3 / d2));
        return d8 < 1.0 ? d8 : 1.0;
    }

    public static double angle(NumberVector numberVector, NumberVector numberVector2, Vector vector) {
        double d;
        double d2;
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = numberVector2.getDimensionality();
        int n4 = vector.getDimensionality();
        int n5 = n2 <= n3 ? n2 : n3;
        double[] dArray = vector.getArrayRef();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n5; ++n) {
            d2 = n < n4 ? dArray[n] : 0.0;
            d = numberVector.doubleValue(n) - d2;
            double d6 = numberVector2.doubleValue(n) - d2;
            d3 += d * d6;
            d4 += d * d;
            d5 += d6 * d6;
        }
        for (n = n5; n < n2; ++n) {
            d2 = n < n4 ? dArray[n] : 0.0;
            d = numberVector.doubleValue(n) - d2;
            d4 += d * d;
        }
        for (n = n5; n < n3; ++n) {
            d2 = n < n4 ? dArray[n] : 0.0;
            d = numberVector2.doubleValue(n) - d2;
            d5 += d * d;
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        if (d4 == 0.0 || d5 == 0.0) {
            return 1.0;
        }
        double d7 = Math.sqrt(d3 / d4 * (d3 / d5));
        return d7 < 1.0 ? d7 : 1.0;
    }

    public static double angle(NumberVector numberVector, NumberVector numberVector2, NumberVector numberVector3) {
        double d;
        double d2;
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = numberVector2.getDimensionality();
        int n4 = numberVector3.getDimensionality();
        int n5 = n2 <= n3 ? n2 : n3;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n5; ++n) {
            d2 = n < n4 ? numberVector3.doubleValue(n) : 0.0;
            d = numberVector.doubleValue(n) - d2;
            double d6 = numberVector2.doubleValue(n) - numberVector3.doubleValue(n);
            d3 += d * d6;
            d4 += d * d;
            d5 += d6 * d6;
        }
        for (n = n5; n < n2; ++n) {
            d2 = n < n4 ? numberVector3.doubleValue(n) : 0.0;
            d = numberVector.doubleValue(n) - d2;
            d4 += d * d;
        }
        for (n = n5; n < n3; ++n) {
            d2 = n < n4 ? numberVector3.doubleValue(n) : 0.0;
            d = numberVector2.doubleValue(n) - d2;
            d5 += d * d;
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        if (d4 == 0.0 || d5 == 0.0) {
            return 1.0;
        }
        double d7 = Math.sqrt(d3 / d4 * (d3 / d5));
        return d7 < 1.0 ? d7 : 1.0;
    }

    public static double cosAngle(NumberVector numberVector, NumberVector numberVector2) {
        double d;
        int n;
        int n2;
        if (numberVector instanceof SparseNumberVector && numberVector2 instanceof SparseNumberVector) {
            return VectorUtil.angleSparse((SparseNumberVector)numberVector, (SparseNumberVector)numberVector2);
        }
        int n3 = numberVector.getDimensionality();
        int n4 = n3 <= (n2 = numberVector2.getDimensionality()) ? n3 : n2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < n4; ++n) {
            d = numberVector.doubleValue(n);
            double d5 = numberVector2.doubleValue(n);
            d2 += d * d5;
            d3 += d * d;
            d4 += d5 * d5;
        }
        for (n = n4; n < n3; ++n) {
            d = numberVector.doubleValue(n);
            d3 += d * d;
        }
        for (n = n4; n < n2; ++n) {
            d = numberVector2.doubleValue(n);
            d4 += d * d;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d3 == 0.0 || d4 == 0.0) {
            return 1.0;
        }
        double d6 = Math.sqrt(d2 / d3 * (d2 / d4));
        return d6 < 1.0 ? d6 : 1.0;
    }

    public static double minCosAngle(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        double d;
        double d2;
        int n;
        int n2;
        if (spatialComparable instanceof NumberVector && spatialComparable2 instanceof NumberVector) {
            return VectorUtil.cosAngle((NumberVector)spatialComparable, (NumberVector)spatialComparable2);
        }
        int n3 = spatialComparable.getDimensionality();
        int n4 = n3 <= (n2 = spatialComparable2.getDimensionality()) ? n3 : n2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n = 0; n < n4; ++n) {
            d2 = spatialComparable.getMin(n);
            d = spatialComparable.getMax(n);
            double d7 = spatialComparable2.getMin(n);
            double d8 = spatialComparable2.getMax(n);
            double d9 = d2 * d7;
            double d10 = d2 * d8;
            double d11 = d * d7;
            double d12 = d * d8;
            d3 += MathUtil.max(d9, d10, d11, d12);
            d4 += MathUtil.min(d9, d10, d11, d12);
            if (d < 0.0) {
                d5 += d * d;
            } else if (d2 > 0.0) {
                d5 += d2 * d2;
            }
            if (d8 < 0.0) {
                d6 += d8 * d8;
                continue;
            }
            if (!(d7 > 0.0)) continue;
            d6 += d7 * d7;
        }
        for (n = n4; n < n3; ++n) {
            d2 = spatialComparable.getMin(n);
            d = spatialComparable.getMax(n);
            if (d < 0.0) {
                d5 += d * d;
                continue;
            }
            if (!(d2 > 0.0)) continue;
            d5 += d2 * d2;
        }
        for (n = n4; n < n2; ++n) {
            d2 = spatialComparable2.getMin(n);
            d = spatialComparable2.getMax(n);
            if (d < 0.0) {
                d6 += d * d;
                continue;
            }
            if (!(d2 > 0.0)) continue;
            d6 += d2 * d2;
        }
        double d13 = MathUtil.max(d3, Math.abs(d4));
        if (d13 == 0.0) {
            return 0.0;
        }
        if (d5 == 0.0 || d6 == 0.0) {
            return 1.0;
        }
        double d14 = Math.sqrt(d13 / d5 * (d13 / d6));
        return d14 < 1.0 ? d14 : 1.0;
    }

    public static double scalarProduct(NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += numberVector.doubleValue(i) * numberVector2.doubleValue(i);
        }
        return d;
    }

    public static Vector computeMedoid(Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        int n = RelationUtil.dimensionality(relation);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new SortDBIDsBySingleDimension(relation);
        Vector vector = new Vector(n);
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        for (int i = 0; i < n; ++i) {
            sortDBIDsBySingleDimension.setDimension(i);
            dBIDArrayMIter.seek(QuickSelect.median(arrayModifiableDBIDs, sortDBIDsBySingleDimension));
            vector.set(i, relation.get(dBIDArrayMIter).doubleValue(i));
        }
        return vector;
    }

    public static double[] fastTimes(Matrix matrix, NumberVector numberVector) {
        double[][] dArray = matrix.getArrayRef();
        int n = matrix.getColumnDimensionality();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray3[j] * numberVector.doubleValue(j);
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static <V extends NumberVector> V project(V v, long[] lArray, NumberVector.Factory<V> factory) {
        int n = BitsUtil.cardinality(lArray);
        if (factory instanceof SparseNumberVector.Factory) {
            SparseNumberVector.Factory factory2 = (SparseNumberVector.Factory)factory;
            TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap(n, 1.0f);
            int n2 = BitsUtil.nextSetBit(lArray, 0);
            while (n2 >= 0) {
                if (v.doubleValue(n2) != 0.0) {
                    tIntDoubleHashMap.put(n2, v.doubleValue(n2));
                }
                n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
            }
            Object v2 = factory2.newNumberVector((TIntDoubleMap)tIntDoubleHashMap, n);
            return v2;
        }
        double[] dArray = new double[n];
        int n3 = 0;
        int n4 = BitsUtil.nextSetBit(lArray, 0);
        while (n4 >= 0) {
            dArray[n3] = v.doubleValue(n4);
            ++n3;
            n4 = BitsUtil.nextSetBit(lArray, n4 + 1);
        }
        return factory.newNumberVector(dArray);
    }

    public static class SortVectorsBySingleDimension
    implements Comparator<NumberVector> {
        private int d;

        public SortVectorsBySingleDimension(int n) {
            this.d = n;
        }

        public SortVectorsBySingleDimension() {
        }

        public int getDimension() {
            return this.d;
        }

        public void setDimension(int n) {
            this.d = n;
        }

        @Override
        public int compare(NumberVector numberVector, NumberVector numberVector2) {
            double d;
            double d2 = numberVector.doubleValue(this.d);
            return d2 < (d = numberVector2.doubleValue(this.d)) ? -1 : (d2 > d ? 1 : 0);
        }
    }

    public static class SortDBIDsBySingleDimension
    implements Comparator<DBIDRef> {
        private int d;
        private Relation<? extends NumberVector> data;

        public SortDBIDsBySingleDimension(Relation<? extends NumberVector> relation, int n) {
            this.data = relation;
            this.d = n;
        }

        public SortDBIDsBySingleDimension(Relation<? extends NumberVector> relation) {
            this.data = relation;
        }

        public int getDimension() {
            return this.d;
        }

        public void setDimension(int n) {
            this.d = n;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            double d;
            double d2 = this.data.get(dBIDRef).doubleValue(this.d);
            return d2 < (d = this.data.get(dBIDRef2).doubleValue(this.d)) ? -1 : (d2 > d ? 1 : 0);
        }
    }
}

