/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.util.Comparator;

public class Subspace {
    private final long[] dimensions;
    private final int dimensionality;

    public Subspace(int n) {
        this.dimensions = BitsUtil.zero(n + 1);
        BitsUtil.setI(this.dimensions, n);
        this.dimensionality = 1;
    }

    public Subspace(long[] lArray) {
        this.dimensions = lArray;
        this.dimensionality = BitsUtil.cardinality(lArray);
    }

    public final long[] getDimensions() {
        return this.dimensions;
    }

    public final int dimensionality() {
        return this.dimensionality;
    }

    public Subspace join(Subspace subspace) {
        long[] lArray = this.joinLastDimensions(subspace);
        if (lArray == null) {
            return null;
        }
        return new Subspace(lArray);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("Dimensions: [");
        int n2 = n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n2 >= 0) {
            if (n2 != n) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n2 + 1);
            n2 = BitsUtil.nextSetBit(this.dimensions, n2 + 1);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String dimensonsToString() {
        return this.dimensonsToString(", ");
    }

    public String dimensonsToString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            if (stringBuilder.length() == 1) {
                stringBuilder.append(n + 1);
            } else {
                stringBuilder.append(string).append(n + 1);
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean isSubspace(Subspace subspace) {
        if (this.dimensionality > subspace.dimensionality) {
            return false;
        }
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            if (!BitsUtil.get(subspace.dimensions, n)) {
                return false;
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return true;
    }

    protected long[] joinLastDimensions(Subspace subspace) {
        if (this.dimensionality != subspace.dimensionality) {
            return null;
        }
        int n = MathUtil.max(this.dimensions.length, subspace.dimensions.length);
        long[] lArray = new long[n];
        int n2 = -1;
        int n3 = -1;
        int n4 = BitsUtil.nextSetBit(this.dimensions, 0);
        int n5 = BitsUtil.nextSetBit(subspace.dimensions, 0);
        while (n4 >= 0 && n5 >= 0) {
            if (n4 == n5) {
                BitsUtil.setI(lArray, n4);
            }
            n2 = n4;
            n3 = n5;
            n4 = BitsUtil.nextSetBit(this.dimensions, n4 + 1);
            n5 = BitsUtil.nextSetBit(subspace.dimensions, n5 + 1);
        }
        if (n2 >= 0 && n3 >= 0 && n2 < n3) {
            BitsUtil.setI(lArray, n2);
            BitsUtil.setI(lArray, n3);
            return lArray;
        }
        return null;
    }

    public int hashCode() {
        return this.dimensions.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Subspace subspace = (Subspace)object;
        return new DimensionComparator().compare(this, subspace) == 0;
    }

    public static class DimensionComparator
    implements Comparator<Subspace> {
        @Override
        public int compare(Subspace subspace, Subspace subspace2) {
            if (subspace == subspace2 || subspace.getDimensions() == null && subspace2.getDimensions() == null) {
                return 0;
            }
            if (subspace.getDimensions() == null && subspace2.getDimensions() != null) {
                return -1;
            }
            if (subspace.getDimensions() != null && subspace2.getDimensions() == null) {
                return 1;
            }
            int n = subspace.dimensionality() - subspace2.dimensionality();
            if (n != 0) {
                return n;
            }
            int n2 = BitsUtil.nextSetBit(subspace.getDimensions(), 0);
            int n3 = BitsUtil.nextSetBit(subspace2.getDimensions(), 0);
            while (n2 >= 0 && n3 >= 0) {
                if (n2 != n3) {
                    return n2 - n3;
                }
                n2 = BitsUtil.nextSetBit(subspace.getDimensions(), n2 + 1);
                n3 = BitsUtil.nextSetBit(subspace2.getDimensions(), n3 + 1);
            }
            return 0;
        }
    }
}

