/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.TIntDoubleMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseIntegerVector
extends AbstractNumberVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseIntegerVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] indexes;
    private final int[] values;
    private int dimensionality;

    public SparseIntegerVector(int[] nArray, int[] nArray2, int n) {
        this.indexes = nArray;
        this.values = nArray2;
        this.dimensionality = n;
    }

    public SparseIntegerVector(TIntDoubleMap tIntDoubleMap, int n) throws IllegalArgumentException {
        int n2;
        if (tIntDoubleMap.size() > n) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[tIntDoubleMap.size()];
        this.values = new int[tIntDoubleMap.size()];
        TIntDoubleIterator tIntDoubleIterator = tIntDoubleMap.iterator();
        int n3 = 0;
        while (tIntDoubleIterator.hasNext()) {
            tIntDoubleIterator.advance();
            this.indexes[n3] = tIntDoubleIterator.key();
            ++n3;
        }
        Arrays.sort(this.indexes);
        for (n2 = 0; n2 < tIntDoubleMap.size(); ++n2) {
            this.values[n2] = (int)tIntDoubleMap.get(this.indexes[n2]);
        }
        this.dimensionality = n;
        n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
    }

    private int getMaxDim() {
        if (this.indexes.length == 0) {
            return 0;
        }
        return this.indexes[this.indexes.length - 1];
    }

    public SparseIntegerVector(int[] nArray) throws IllegalArgumentException {
        int n;
        this.dimensionality = nArray.length;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            ++n2;
        }
        this.indexes = new int[n2];
        this.values = new int[n2];
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            this.indexes[n] = i;
            this.values[n] = n3;
            ++n;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int n) throws IllegalArgumentException {
        int n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
        this.dimensionality = n;
    }

    @Override
    @Deprecated
    public Integer getValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0;
    }

    @Override
    @Deprecated
    public double doubleValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0L;
    }

    @Override
    @Deprecated
    public int intValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0;
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(this.getValues());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.indexes[i]);
            stringBuilder.append(" ");
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    private double[] getValues() {
        double[] dArray = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            dArray[this.indexes[i]] = this.values[i];
        }
        return dArray;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public int iterDim(int n) {
        return this.indexes[n];
    }

    @Override
    public int iterAdvance(int n) {
        return n + 1;
    }

    @Override
    public boolean iterValid(int n) {
        return n < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int n) {
        return this.values[n];
    }

    @Override
    public float iterFloatValue(int n) {
        return this.values[n];
    }

    @Override
    public int iterIntValue(int n) {
        return this.values[n];
    }

    @Override
    public short iterShortValue(int n) {
        return (short)this.values[n];
    }

    @Override
    public long iterLongValue(int n) {
        return this.values[n];
    }

    @Override
    public byte iterByteValue(int n) {
        return (byte)this.values[n];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseIntegerVector> {
        @Override
        public SparseIntegerVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int n2 = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = ByteArrayUtil.readUnsignedVarint(byteBuffer);
                nArray2[i] = ByteArrayUtil.readSignedVarint(byteBuffer);
            }
            return new SparseIntegerVector(nArray, nArray2, n);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, SparseIntegerVector sparseIntegerVector) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseIntegerVector.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseIntegerVector.values.length);
            for (int i = 0; i < sparseIntegerVector.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseIntegerVector.indexes[i]);
                ByteArrayUtil.writeSignedVarint(byteBuffer, sparseIntegerVector.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseIntegerVector sparseIntegerVector) {
            int n = 0;
            n += ByteArrayUtil.getUnsignedVarintSize(sparseIntegerVector.dimensionality);
            n += ByteArrayUtil.getUnsignedVarintSize(sparseIntegerVector.values.length);
            for (int i = 0; i < sparseIntegerVector.values.length; ++i) {
                n += ByteArrayUtil.getUnsignedVarintSize(sparseIntegerVector.indexes[i]);
                n += ByteArrayUtil.getSignedVarintSize(sparseIntegerVector.values[i]);
            }
            return n;
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<SparseIntegerVector>
    implements SparseNumberVector.Factory<SparseIntegerVector> {
        @Override
        public <A> SparseIntegerVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = arrayAdapter.get(a, i).intValue();
            }
            return new SparseIntegerVector(nArray);
        }

        @Override
        public <A> SparseIntegerVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = numberArrayAdapter.getInteger(a, i);
            }
            return new SparseIntegerVector(nArray);
        }

        @Override
        public SparseIntegerVector newNumberVector(TIntDoubleMap tIntDoubleMap, int n) {
            return new SparseIntegerVector(tIntDoubleMap, n);
        }

        @Override
        public ByteBufferSerializer<SparseIntegerVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseIntegerVector> getRestrictionClass() {
            return SparseIntegerVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

