/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import java.util.Arrays;

public class ModifiableHyperBoundingBox
extends HyperBoundingBox {
    private static final long serialVersionUID = 1L;

    public ModifiableHyperBoundingBox() {
    }

    public ModifiableHyperBoundingBox(SpatialComparable spatialComparable) {
        super(SpatialUtil.getMin(spatialComparable), SpatialUtil.getMax(spatialComparable));
    }

    public ModifiableHyperBoundingBox(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("min/max need same dimensionality");
        }
        this.min = dArray;
        this.max = dArray2;
    }

    public ModifiableHyperBoundingBox(int n, double d, double d2) {
        this.min = new double[n];
        this.max = new double[n];
        Arrays.fill(this.min, d);
        Arrays.fill(this.max, d2);
    }

    public void setMax(int n, double d) {
        this.max[n] = d;
    }

    public void setMin(int n, double d) {
        this.min[n] = d;
    }

    public double[] getMinRef() {
        return this.min;
    }

    public double[] getMaxRef() {
        return this.max;
    }

    public boolean extend(SpatialComparable spatialComparable) {
        int n = this.min.length;
        assert (!LoggingConfiguration.DEBUG || spatialComparable.getDimensionality() == n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            double d = spatialComparable.getMin(i);
            double d2 = spatialComparable.getMax(i);
            if (d < this.min[i]) {
                this.min[i] = d;
                bl = true;
            }
            if (!(d2 > this.max[i])) continue;
            this.max[i] = d2;
            bl = true;
        }
        return bl;
    }
}

