/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.jsmap;

import java.util.Stack;

public class JSONBuffer {
    final StringBuilder buffer;
    final Stack<Operand> stack = new Stack();

    public JSONBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public static String jsonEscapeString(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public JSONBuffer appendString(Object object) {
        if (this.stack.empty() || this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("Appending string outside of array context.");
        }
        this.addQuotedString(object);
        this.addSeparator();
        return this;
    }

    public JSONBuffer append(double d) {
        if (this.stack.empty() || this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("Appending double outside of array context.");
        }
        this.buffer.append(Double.toString(d));
        this.addSeparator();
        return this;
    }

    public JSONBuffer append(int n) {
        if (this.stack.empty() || this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("Appending double outside of array context.");
        }
        this.buffer.append(Integer.toString(n));
        this.addSeparator();
        return this;
    }

    public JSONBuffer append(double[] dArray) {
        this.startArray();
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                this.buffer.append(",");
            }
            this.buffer.append(Double.toString(dArray[i]));
        }
        this.closeArray();
        return this;
    }

    public JSONBuffer append(int[] nArray) {
        this.startArray();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                this.buffer.append(",");
            }
            this.buffer.append(Integer.toString(nArray[i]));
        }
        this.closeArray();
        return this;
    }

    private void addQuotedString(Object object) {
        String string = object instanceof String ? (String)object : (object == null ? "null" : object.toString());
        this.buffer.append("\"").append(JSONBuffer.jsonEscapeString(string)).append("\"");
    }

    public JSONBuffer appendKeyValue(Object object, Object object2) {
        if (this.stack.empty() || this.stack.peek() != Operand.HASH) {
            throw new JSONException("Appending key-value outside of hash context.");
        }
        this.addQuotedString(object);
        this.buffer.append(":");
        if (object2 instanceof Double) {
            this.buffer.append(object2.toString());
        } else if (object2 instanceof Integer) {
            this.buffer.append(object2.toString());
        } else {
            this.addQuotedString(object2);
        }
        this.buffer.append(",");
        return this;
    }

    public JSONBuffer appendKeyHash(Object object) {
        if (this.stack.empty() || this.stack.peek() != Operand.HASH) {
            throw new JSONException("Appending key-value outside of hash context.");
        }
        this.addQuotedString(object);
        this.buffer.append(":");
        this.buffer.append("{");
        this.stack.push(Operand.HASH);
        return this;
    }

    public JSONBuffer appendKeyArray(Object object) {
        if (this.stack.empty() || this.stack.peek() != Operand.HASH) {
            throw new JSONException("Appending key-value outside of hash context.");
        }
        this.addQuotedString(object);
        this.buffer.append(":");
        this.buffer.append("[");
        this.stack.push(Operand.ARRAY);
        return this;
    }

    public JSONBuffer startArray() {
        if (!this.stack.empty() && this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("startArray() is only allowed in an empty context.");
        }
        this.buffer.append("[");
        this.stack.push(Operand.ARRAY);
        return this;
    }

    public JSONBuffer startHash() {
        if (!this.stack.empty() && this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("startHash() is only allowed in an empty context.");
        }
        this.buffer.append("{");
        this.stack.push(Operand.HASH);
        return this;
    }

    public JSONBuffer closeArray() {
        if (this.stack.empty() || this.stack.peek() != Operand.ARRAY) {
            throw new JSONException("Not in array context when closing.");
        }
        this.removeSeparator();
        this.buffer.append("]");
        this.stack.pop();
        this.addSeparator();
        return this;
    }

    public JSONBuffer closeHash() {
        if (this.stack.empty() || this.stack.peek() != Operand.HASH) {
            throw new JSONException("Not in array context when closing.");
        }
        this.removeSeparator();
        this.buffer.append("}");
        this.stack.pop();
        this.addSeparator();
        return this;
    }

    private void removeSeparator() {
        if (this.buffer.charAt(this.buffer.length() - 1) == ',') {
            this.buffer.deleteCharAt(this.buffer.length() - 1);
        }
    }

    private void addSeparator() {
        if (this.stack.empty()) {
            return;
        }
        switch (this.stack.peek()) {
            case HASH: 
            case ARRAY: {
                this.buffer.append(",");
                break;
            }
        }
    }

    public JSONBuffer appendNewline() {
        this.buffer.append("\n");
        return this;
    }

    public static class JSONException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JSONException() {
        }

        public JSONException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public JSONException(String string) {
            super(string);
        }

        public JSONException(Throwable throwable) {
            super(throwable);
        }
    }

    static enum Operand {
        HASH,
        ARRAY;

    }
}

