/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.scores.AveragePrecisionEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.MaximumF1Evaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.PrecisionAtKEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.AbstractVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.IncreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvaluatePrecomputedOutlierScores
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(EvaluatePrecomputedOutlierScores.class);
    InputStep inputstep;
    Pattern reverse;
    File outfile;
    String name;

    public EvaluatePrecomputedOutlierScores(InputStep inputStep, Pattern pattern, File file, String string) {
        this.inputstep = inputStep;
        this.reverse = pattern;
        this.outfile = file;
        this.name = string;
    }

    @Override
    public void run() {
        DBID dBID;
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<String> relation2 = DatabaseUtil.guessLabelRepresentation(database);
        String string = relation2.get(dBID = DBIDUtil.deref(relation2.iterDBIDs()));
        if (!string.matches("bylabel")) {
            throw new AbortException("No 'by label' reference outlier found, which is needed for evaluation!");
        }
        NumberVector numberVector = (NumberVector)relation.get(dBID);
        VectorNonZero vectorNonZero = new VectorNonZero(numberVector);
        double d = (double)vectorNonZero.numPositive() / (double)numberVector.getDimensionality();
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.outfile, true);
             PrintStream printStream = new PrintStream(fileOutputStream);
             FileChannel fileChannel = fileOutputStream.getChannel();){
            fileChannel.lock();
            if (fileChannel.position() == 0L) {
                if (this.name != null) {
                    printStream.append("\"Name\",");
                }
                printStream.append("\"Algorithm\",\"k\"");
                printStream.append(",\"ROC AUC\"");
                printStream.append(",\"Average Precision\"");
                printStream.append(",\"R-Precision\"");
                printStream.append(",\"Maximum F1\"");
                printStream.append(",\"Adjusted ROC AUC\"");
                printStream.append(",\"Adjusted Average Precision\"");
                printStream.append(",\"Adjusted R-Precision\"");
                printStream.append(",\"Adjusted Maximum F1\"");
                printStream.append('\n');
            }
            Matcher matcher = this.reverse.matcher("");
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal(dBID, dBIDIter)) {
                    String string2 = relation2.get(dBIDIter);
                    NumberVector numberVector2 = (NumberVector)relation.get(dBIDIter);
                    if (this.checkForNaNs(numberVector2)) {
                        LOG.warning("NaN value encountered in vector " + string2);
                    } else {
                        AbstractVectorIter abstractVectorIter = matcher.reset(string2).find() ? new IncreasingVectorIter(numberVector2) : new DecreasingVectorIter(numberVector2);
                        double d2 = ROCEvaluation.STATIC.evaluate(vectorNonZero, abstractVectorIter.seek(0));
                        double d3 = AveragePrecisionEvaluation.STATIC.evaluate(vectorNonZero, abstractVectorIter.seek(0));
                        double d4 = PrecisionAtKEvaluation.RPRECISION.evaluate(vectorNonZero, abstractVectorIter.seek(0));
                        double d5 = MaximumF1Evaluation.STATIC.evaluate(vectorNonZero, abstractVectorIter.seek(0));
                        double d6 = 2.0 * d2 - 1.0;
                        double d7 = (d4 - d) / (1.0 - d);
                        double d8 = (d3 - d) / (1.0 - d);
                        double d9 = (d5 - d) / (1.0 - d);
                        String string3 = string2.substring(0, string2.lastIndexOf(45));
                        int n = Integer.valueOf(string2.substring(string2.lastIndexOf(45) + 1));
                        if (this.name != null) {
                            printStream.append("\"" + this.name + "\",");
                        }
                        printStream.append("\"" + string3 + "\"," + n);
                        printStream.append(',').append(Double.toString(d2));
                        printStream.append(',').append(Double.toString(d3));
                        printStream.append(',').append(Double.toString(d4));
                        printStream.append(',').append(Double.toString(d5));
                        printStream.append(',').append(Double.toString(d6));
                        printStream.append(',').append(Double.toString(d8));
                        printStream.append(',').append(Double.toString(d7));
                        printStream.append(',').append(Double.toString(d9));
                        printStream.append('\n');
                    }
                }
                dBIDIter.advance();
            }
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
    }

    private boolean checkForNaNs(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        for (int i = 0; i < n; ++i) {
            double d = numberVector.doubleValue(i);
            if (d == d) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        EvaluatePrecomputedOutlierScores.runCLIApplication(EvaluatePrecomputedOutlierScores.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID NAME_ID = new OptionID("name", "Data set name to use in a 'Name' CSV column.");
        public static final OptionID REVERSED_ID = new OptionID("reversed", "Pattern to recognize reversed methods.");
        InputStep inputstep;
        Pattern reverse;
        File outfile;
        String name;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            PatternParameter patternParameter;
            super.makeOptions(parameterization);
            this.inputstep = parameterization.tryInstantiate(InputStep.class);
            this.outfile = super.getParameterOutputFile(parameterization, "File to output the resulting score vectors to.");
            StringParameter stringParameter = new StringParameter(NAME_ID);
            stringParameter.setOptional(true);
            if (parameterization.grab(stringParameter)) {
                this.name = (String)stringParameter.getValue();
            }
            if (parameterization.grab(patternParameter = new PatternParameter(REVERSED_ID, "(ODIN|ABOD)"))) {
                this.reverse = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected EvaluatePrecomputedOutlierScores makeInstance() {
            return new EvaluatePrecomputedOutlierScores(this.inputstep, this.reverse, this.outfile, this.name);
        }
    }
}

