/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.geo;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphereUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class VisualizeGeodesicDistances
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(VisualizeGeodesicDistances.class);
    private File out;
    protected int width = 2000;
    protected int height = 1000;
    protected int steps = 10;
    protected Mode mode = Mode.XTD;
    protected EarthModel model;

    public VisualizeGeodesicDistances(File file, int n, int n2, Mode mode, EarthModel earthModel) {
        this.width = n;
        this.height = n >> 1;
        this.out = file;
        this.steps = n2;
        this.mode = mode;
        this.model = earthModel;
    }

    @Override
    public void run() throws UnableToComplyException {
        DoubleVector doubleVector = new DoubleVector(new double[]{48.133333, 11.566667});
        DoubleVector doubleVector2 = new DoubleVector(new double[]{40.712778, -74.005833});
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox(new double[]{47.2701115, 8.9763497}, new double[]{50.5647142, 13.8396371});
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        double d = this.model.getEquatorialRadius() * Math.PI;
        int n = -65536;
        int n2 = -16711936;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("columns", this.width, LOG) : null;
        for (int i = 0; i < this.width; ++i) {
            double d2 = (double)i * 360.0 / (double)this.width - 180.0;
            block8: for (int j = 0; j < this.height; ++j) {
                double d3 = (double)j * -180.0 / (double)this.height + 90.0;
                switch (this.mode) {
                    case ATD: {
                        double d4 = this.model.getEquatorialRadius() * SphereUtil.alongTrackDistanceDeg(doubleVector.doubleValue(0), doubleVector.doubleValue(1), doubleVector2.doubleValue(0), doubleVector2.doubleValue(1), d3, d2);
                        if (d4 < 0.0) {
                            bufferedImage.setRGB(i, j, this.colorMultiply(n, -d4 / d, false));
                            continue block8;
                        }
                        bufferedImage.setRGB(i, j, this.colorMultiply(n2, d4 / d, false));
                        continue block8;
                    }
                    case XTD: {
                        double d4 = this.model.getEquatorialRadius() * SphereUtil.crossTrackDistanceDeg(doubleVector.doubleValue(0), doubleVector.doubleValue(1), doubleVector2.doubleValue(0), doubleVector2.doubleValue(1), d3, d2);
                        if (d4 < 0.0) {
                            bufferedImage.setRGB(i, j, this.colorMultiply(n, -d4 / d, false));
                            continue block8;
                        }
                        bufferedImage.setRGB(i, j, this.colorMultiply(n2, d4 / d, false));
                        continue block8;
                    }
                    case MINDIST: {
                        double d4 = this.model.minDistDeg(d3, d2, modifiableHyperBoundingBox.getMin(0), modifiableHyperBoundingBox.getMin(1), modifiableHyperBoundingBox.getMax(0), modifiableHyperBoundingBox.getMax(1));
                        if (d4 < 0.0) {
                            bufferedImage.setRGB(i, j, this.colorMultiply(n, -d4 / d, true));
                            continue block8;
                        }
                        bufferedImage.setRGB(i, j, this.colorMultiply(n2, d4 / d, true));
                        continue block8;
                    }
                }
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", this.out);
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
    }

    private int colorMultiply(int n, double d, boolean bl) {
        double d2;
        double d3;
        double d4;
        if (this.steps > 0) {
            d = !bl ? (double)(Math.round(d * (double)this.steps) / (long)this.steps) : Math.ceil(d * (double)this.steps) / (double)this.steps;
        } else if (this.steps < 0 && d > 0.0 && (d4 = Math.abs((d3 = d * (double)(-this.steps)) - (double)Math.round(d3))) < (d2 = (double)(-this.steps) * 1.0 / 1000.0)) {
            d2 = d4 / d2;
            int n2 = n >> 24 & 0xFF;
            n2 = (int)((double)n2 * Math.sqrt(d)) & 0xFF;
            n2 = (int)((1.0 - d2) * 255.0 + d2 * (double)n2);
            int n3 = (int)(d2 * (double)(n >> 16 & 0xFF));
            int n4 = (int)(d2 * (double)(n >> 8 & 0xFF));
            int n5 = (int)(d2 * (double)(n & 0xFF));
            return n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        int n6 = n >> 24 & 0xFF;
        int n7 = n >> 16 & 0xFF;
        int n8 = n >> 8 & 0xFF;
        int n9 = n & 0xFF;
        n6 = (int)((double)n6 * Math.sqrt(d)) & 0xFF;
        return n6 << 24 | n7 << 16 | n8 << 8 | n9;
    }

    public static void main(String[] stringArray) {
        VisualizeGeodesicDistances.runCLIApplication(VisualizeGeodesicDistances.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID STEPS_ID = new OptionID("geodistvis.steps", "Number of steps for the distance map. Use negative numbers to get contour lines.");
        public static final OptionID RESOLUTION_ID = new OptionID("geodistvis.resolution", "Horizontal resolution for the image map (vertical resolution is horizonal / 2).");
        public static final OptionID MODE_ID = new OptionID("geodistvis.mode", "Visualization mode.");
        protected File out = null;
        protected int steps = 0;
        protected int resolution = 2000;
        protected Mode mode = Mode.XTD;
        protected EarthModel model;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            EnumParameter<Mode> enumParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            this.out = super.getParameterOutputFile(parameterization, "Output image file name.");
            IntParameter intParameter2 = new IntParameter(STEPS_ID);
            intParameter2.setOptional(true);
            if (parameterization.grab(intParameter2)) {
                this.steps = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(RESOLUTION_ID, 2000))) {
                this.resolution = intParameter.intValue();
            }
            if (parameterization.grab(enumParameter = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.XTD))) {
                this.mode = (Mode)((Object)enumParameter.getValue());
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class))) {
                this.model = (EarthModel)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected VisualizeGeodesicDistances makeInstance() {
            return new VisualizeGeodesicDistances(this.out, this.resolution, this.steps, this.mode, this.model);
        }
    }

    public static enum Mode {
        XTD,
        ATD,
        MINDIST;

    }
}

