/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;

public abstract class AbstractApplication {
    private static final Logging LOG = Logging.getLogger(AbstractApplication.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String VERSION;
    private static final String REFERENCE_VERSION = "0.7.0";
    @Reference(authors="Erich Schubert, Alexander Koos, Tobias Emrich, Andreas Z\u00fcfle, Klaus Arthur Schmid, Arthur Zimek", title="A Framework for Clustering Uncertain Data", booktitle="Proceedings of the VLDB Endowment, 8(12)", url="http://www.vldb.org/pvldb/vol8/p1976-schubert.pdf")
    public static final String REFERENCE;

    public static void runCLIApplication(Class<?> clazz, String[] stringArray) {
        Flag flag = new Flag(Parameterizer.HELP_ID);
        Flag flag2 = new Flag(Parameterizer.HELP_LONG_ID);
        ClassParameter classParameter = new ClassParameter(Parameterizer.DESCRIPTION_ID, Object.class, true);
        StringParameter stringParameter = new StringParameter(Parameterizer.DEBUG_ID);
        Flag flag3 = new Flag(Parameterizer.VERBOSE_ID);
        stringParameter.setOptional(true);
        SerializedParameterization serializedParameterization = new SerializedParameterization(stringArray);
        try {
            serializedParameterization.grab(flag);
            serializedParameterization.grab(flag2);
            serializedParameterization.grab(classParameter);
            serializedParameterization.grab(stringParameter);
            if (classParameter.isDefined()) {
                serializedParameterization.clearErrors();
                AbstractApplication.printDescription((Class)classParameter.getValue());
                return;
            }
            if (serializedParameterization.getErrors().size() > 0) {
                serializedParameterization.logAndClearReportedErrors();
                return;
            }
            if (stringParameter.isDefined()) {
                Parameterizer.parseDebugParameter(stringParameter);
            }
        }
        catch (Exception exception) {
            AbstractApplication.printErrorMessage(exception);
            return;
        }
        try {
            Object object;
            TrackParameters trackParameters = new TrackParameters(serializedParameterization);
            if (trackParameters.grab(flag3) && flag3.isTrue()) {
                object = new Flag(Parameterizer.VERBOSE_ID);
                if (trackParameters.grab((Parameter<?>)object) && ((Flag)object).isTrue()) {
                    LoggingConfiguration.setVerbose(Logging.Level.VERYVERBOSE);
                } else {
                    LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
                }
            }
            object = ClassGenericsUtil.tryInstantiate(AbstractApplication.class, clazz, trackParameters);
            if (flag.isDefined() && ((Boolean)flag.getValue()).booleanValue() || flag2.isDefined() && ((Boolean)flag2.getValue()).booleanValue()) {
                LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
                LOG.verbose(AbstractApplication.usage(trackParameters.getAllParameters()));
            } else {
                serializedParameterization.logUnusedParameters();
                if (serializedParameterization.getErrors().size() > 0) {
                    LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
                    LOG.verbose("The following configuration errors prevented execution:\n");
                    for (ParameterException parameterException : serializedParameterization.getErrors()) {
                        LOG.verbose(parameterException.getMessage());
                    }
                    LOG.verbose("\n");
                    LOG.verbose("Stopping execution because of configuration errors.");
                    System.exit(1);
                } else {
                    ((AbstractApplication)object).run();
                }
            }
        }
        catch (Exception exception) {
            AbstractApplication.printErrorMessage(exception);
        }
    }

    public static String usage(Collection<TrackedParameter> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!REFERENCE_VERSION.equals(VERSION)) {
            stringBuilder.append("ELKI build: " + VERSION + NEWLINE + NEWLINE);
        }
        stringBuilder.append(REFERENCE);
        stringBuilder.append(NEWLINE).append("Parameters:").append(NEWLINE);
        OptionUtil.formatForConsole(stringBuilder, FormatUtil.getConsoleWidth(), "   ", collection);
        return stringBuilder.toString();
    }

    protected static void printErrorMessage(Exception exception) {
        if (exception instanceof AbortException) {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
            LOG.verbose(exception.getMessage());
        } else if (exception instanceof UnspecifiedParameterException) {
            LOG.error(exception.getMessage());
        } else if (exception instanceof ParameterException) {
            LOG.error(exception.getMessage());
        } else {
            LOG.exception(exception);
        }
    }

    private static void printDescription(Class<?> clazz) {
        if (clazz != null) {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
            LOG.verbose(OptionUtil.describeParameterizable(new StringBuilder(), clazz, FormatUtil.getConsoleWidth(), "    ").toString());
        }
    }

    public abstract void run() throws UnableToComplyException;

    static {
        String string = "DEVELOPMENT";
        try {
            Properties properties = new Properties();
            properties.load(AbstractApplication.class.getClassLoader().getResourceAsStream("META-INF/elki.properties"));
            string = properties.getProperty("elki.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VERSION = string;
        REFERENCE = "ELKI Release 0.7.0 (2015, August) published in:" + NEWLINE + NEWLINE + "Erich Schubert, Alexander Koos, Tobias Emrich," + NEWLINE + "Andreas Z\u00fcfle, Klaus Arthur Schmid, Arthur Zimek:" + NEWLINE + "A Framework for Clustering Uncertain Data." + NEWLINE + "In Proceedings of the VLDB Endowment, 8(12), 2015." + NEWLINE;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUTPUT_ID = new OptionID("app.out", "");
        public static final OptionID INPUT_ID = new OptionID("app.in", "");
        public static final OptionID HELP_ID = new OptionID("h", "Request a help-message, either for the main-routine or for any specified algorithm. Causes immediate stop of the program.");
        public static final OptionID HELP_LONG_ID = new OptionID("help", "Request a help-message, either for the main-routine or for any specified algorithm. Causes immediate stop of the program.");
        public static final OptionID DESCRIPTION_ID = new OptionID("description", "Class to obtain a description of. Causes immediate stop of the program.");
        public static final OptionID DEBUG_ID = new OptionID("enableDebug", "Parameter to enable debugging for particular packages.");
        public static final OptionID VERBOSE_ID = new OptionID("verbose", "Enable verbose messages.");

        protected File getParameterOutputFile(Parameterization parameterization) {
            return this.getParameterOutputFile(parameterization, "Output filename.");
        }

        protected File getParameterOutputFile(Parameterization parameterization, String string) {
            FileParameter fileParameter = new FileParameter(OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE);
            fileParameter.setShortDescription(string);
            if (parameterization.grab(fileParameter)) {
                return (File)fileParameter.getValue();
            }
            return null;
        }

        protected File getParameterInputFile(Parameterization parameterization) {
            return this.getParameterInputFile(parameterization, "Input filename.");
        }

        protected File getParameterInputFile(Parameterization parameterization, String string) {
            FileParameter fileParameter = new FileParameter(INPUT_ID, FileParameter.FileType.INPUT_FILE);
            fileParameter.setShortDescription(string);
            if (parameterization.grab(fileParameter)) {
                return (File)fileParameter.getValue();
            }
            return null;
        }

        public static final void parseDebugParameter(StringParameter stringParameter) throws WrongParameterValueException {
            String[] stringArray;
            for (String string : stringArray = ((String)stringParameter.getValue()).split(",")) {
                try {
                    String[] stringArray2 = string.split("=");
                    if (stringArray2.length == 1) {
                        try {
                            Level level = Logging.Level.parse(stringArray2[0]);
                            LoggingConfiguration.setDefaultLevel(level);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LoggingConfiguration.setLevelFor(stringArray2[0], Logging.Level.FINEST.getName());
                        }
                        continue;
                    }
                    if (stringArray2.length == 2) {
                        LoggingConfiguration.setLevelFor(stringArray2[0], stringArray2[1]);
                        continue;
                    }
                    throw new WrongParameterValueException(stringParameter, (String)stringParameter.getValue(), "More than one '=' in debug parameter.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new WrongParameterValueException(stringParameter, (String)stringParameter.getValue(), "Could not process value.", illegalArgumentException);
                }
            }
        }

        @Override
        protected abstract AbstractApplication makeInstance();
    }
}

