/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Reference(authors="E. M\u00fcller, M. Schiffer, T. Seidl", title="Adaptive outlierness for subspace outlier ranking", booktitle="Proc. 19th ACM International Conference on Information and knowledge management")
public class OUTRES<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OUTRES.class);
    private final double eps;
    private static final double K_S_CRITICAL001 = 1.63;

    public OUTRES(double d) {
        this.eps = d;
    }

    public OutlierResult run(Relation<V> relation) {
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        KernelDensityEstimator kernelDensityEstimator = new KernelDensityEstimator(relation);
        long[] lArray = BitsUtil.zero(kernelDensityEstimator.dim);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("OUTRES scores", relation.size(), LOG) : null;
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            BitsUtil.zeroI(lArray);
            double d = this.outresScore(0, lArray, (DBIDRef)object, kernelDensityEstimator);
            writableDoubleDataStore.putDouble((DBIDRef)object, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, 1.0, 1.0);
        OutlierResult outlierResult = new OutlierResult((OutlierScoreMeta)object, new MaterializedDoubleRelation("OUTRES", "outres-score", writableDoubleDataStore, relation.getDBIDs()));
        return outlierResult;
    }

    public double outresScore(int n, long[] lArray, DBIDRef dBIDRef, KernelDensityEstimator kernelDensityEstimator) {
        double d = 1.0;
        SubspaceEuclideanDistanceFunction subspaceEuclideanDistanceFunction = new SubspaceEuclideanDistanceFunction(lArray);
        MeanVariance meanVariance = new MeanVariance();
        for (int i = n; i < kernelDensityEstimator.dim; ++i) {
            if (BitsUtil.get(lArray, i)) continue;
            BitsUtil.setI(lArray, i);
            subspaceEuclideanDistanceFunction.setSelectedDimensions(lArray);
            double d2 = kernelDensityEstimator.adjustedEps(kernelDensityEstimator.dim);
            double d3 = d2 * 2.0;
            RangeQuery<NumberVector> rangeQuery = QueryUtil.getRangeQuery(kernelDensityEstimator.relation, subspaceEuclideanDistanceFunction, d3);
            DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDRef, d3);
            DoubleDBIDList doubleDBIDList2 = this.refineRange(doubleDBIDList, d2);
            if (doubleDBIDList2.size() > 2 && this.relevantSubspace(lArray, doubleDBIDList2, kernelDensityEstimator)) {
                double d4 = kernelDensityEstimator.subspaceDensity(lArray, doubleDBIDList2);
                meanVariance.reset();
                DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList2.iter();
                while (doubleDBIDListIter.valid()) {
                    DoubleDBIDList doubleDBIDList3 = this.subsetNeighborhoodQuery(doubleDBIDList, doubleDBIDListIter, subspaceEuclideanDistanceFunction, d2, kernelDensityEstimator);
                    meanVariance.put(kernelDensityEstimator.subspaceDensity(lArray, doubleDBIDList3));
                    doubleDBIDListIter.advance();
                }
                double d5 = (meanVariance.getMean() - d4) / (2.0 * meanVariance.getSampleStddev());
                if (d5 >= 1.0) {
                    d *= d4 / d5;
                }
                d *= this.outresScore(i + 1, lArray, dBIDRef, kernelDensityEstimator);
            }
            BitsUtil.clearI(lArray, i);
        }
        return d;
    }

    private DoubleDBIDList refineRange(DoubleDBIDList doubleDBIDList, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(doubleDBIDList.size());
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            DoubleDBIDPair doubleDBIDPair = doubleDBIDListIter.getPair();
            double d2 = doubleDBIDPair.doubleValue();
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, doubleDBIDPair);
            }
            doubleDBIDListIter.advance();
        }
        return modifiableDoubleDBIDList;
    }

    private DoubleDBIDList subsetNeighborhoodQuery(DoubleDBIDList doubleDBIDList, DBIDRef dBIDRef, PrimitiveDistanceFunction<? super V> primitiveDistanceFunction, double d, KernelDensityEstimator kernelDensityEstimator) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(doubleDBIDList.size());
        NumberVector numberVector = (NumberVector)kernelDensityEstimator.relation.get(dBIDRef);
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            DoubleDBIDPair doubleDBIDPair = doubleDBIDListIter.getPair();
            double d2 = primitiveDistanceFunction.distance(numberVector, kernelDensityEstimator.relation.get(doubleDBIDPair));
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, doubleDBIDPair);
            }
            doubleDBIDListIter.advance();
        }
        return modifiableDoubleDBIDList;
    }

    protected boolean relevantSubspace(long[] lArray, DoubleDBIDList doubleDBIDList, KernelDensityEstimator kernelDensityEstimator) {
        Relation relation = kernelDensityEstimator.relation;
        double d = 1.63 / Math.sqrt(doubleDBIDList.size());
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n > 0) {
            double[] dArray = new double[doubleDBIDList.size()];
            int n2 = 0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                NumberVector numberVector = (NumberVector)relation.get(doubleDBIDListIter);
                dArray[n2] = numberVector.doubleValue(n);
                ++n2;
                doubleDBIDListIter.advance();
            }
            assert (n2 == doubleDBIDList.size());
            Arrays.sort(dArray);
            double d2 = dArray[dArray.length - 1] - dArray[0];
            double d3 = dArray[0];
            for (int i = 1; i < dArray.length - 2; ++i) {
                double d4 = (double)i / ((double)dArray.length - 1.0) - (dArray[i] - d3) / d2;
                if (!(Math.abs(d4) > d)) continue;
                return false;
            }
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID D_ID = new OptionID("outres.epsilon", "Range value for OUTRES in 2 dimensions.");
        protected double eps;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(D_ID);
            if (parameterization.grab(doubleParameter)) {
                this.eps = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected OUTRES<O> makeInstance() {
            return new OUTRES(this.eps);
        }
    }

    protected class KernelDensityEstimator {
        final KernelDensityFunction kernel = EpanechnikovKernelDensityFunction.KERNEL;
        final Relation<V> relation;
        final double[] epsilons;
        final double hopttwo;
        final int dim;

        public KernelDensityEstimator(Relation<V> relation) {
            this.relation = relation;
            this.dim = RelationUtil.dimensionality(relation);
            this.hopttwo = this.optimalBandwidth(2);
            this.epsilons = new double[this.dim + 1];
            Arrays.fill(this.epsilons, Double.NEGATIVE_INFINITY);
            this.epsilons[2] = OUTRES.this.eps;
        }

        protected double subspaceDensity(long[] lArray, DoubleDBIDList doubleDBIDList) {
            double d = this.optimalBandwidth(BitsUtil.cardinality(lArray));
            double d2 = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                double d3 = doubleDBIDListIter.doubleValue() / d;
                if (d3 < 1.0) {
                    d2 += 1.0 - d3 * d3;
                }
                doubleDBIDListIter.advance();
            }
            return d2 / (double)this.relation.size();
        }

        protected double optimalBandwidth(int n) {
            double d = 8.0 * GammaDistribution.gamma((double)n / 2.0 + 1.0) * (double)(n + 4) * MathUtil.powi(2.0, n);
            return d * Math.pow(this.relation.size(), -1.0 / (double)(n + 4));
        }

        protected double adjustedEps(int n) {
            double d = this.epsilons[n];
            if (d < 0.0) {
                this.epsilons[n] = d = this.epsilons[2] * this.optimalBandwidth(n) / this.hopttwo;
            }
            return d;
        }
    }
}

