/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.outlier.subspace.AbstractAggarwalYuOutlier;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import java.util.ArrayList;
import java.util.Iterator;

@Title(value="BruteForce: Outlier detection for high dimensional data")
@Description(value="Examines all possible sets of k dimensional projections")
@Reference(authors="C.C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001), Santa Barbara, CA, 2001", url="http://dx.doi.org/10.1145/375663.375668")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.AggarwalYuNaive"})
public class AggarwalYuNaive<V extends NumberVector>
extends AbstractAggarwalYuOutlier<V> {
    private static final Logging LOG = Logging.getLogger(AggarwalYuNaive.class);

    public AggarwalYuNaive(int n, int n2) {
        super(n, n2);
    }

    public OutlierResult run(Relation<V> relation) {
        Object object;
        ArrayList arrayList;
        int n;
        int n2 = RelationUtil.dimensionality(relation);
        int n3 = relation.size();
        ArrayList<ArrayList<DBIDs>> arrayList2 = this.buildRanges(relation);
        ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
        Object object2 = new ArrayList();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < this.phi; ++i) {
                IntIntPair intIntPair = new IntIntPair(n, i);
                ((ArrayList)object2).add(intIntPair);
                arrayList = new ArrayList();
                arrayList.add(intIntPair);
                arrayList3.add(arrayList);
            }
        }
        for (n = 2; n <= this.k; ++n) {
            ArrayList arrayList4 = new ArrayList();
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList = (ArrayList)arrayList3.get(i);
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    object = (IntIntPair)iterator.next();
                    boolean bl = false;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (((IntIntPair)arrayList.get((int)j)).first != ((IntIntPair)object).first) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    ArrayList<Object> arrayList5 = new ArrayList<Object>(arrayList);
                    arrayList5.add(object);
                    arrayList4.add(arrayList5);
                }
            }
            arrayList3 = arrayList4;
        }
        object2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 6);
        for (ArrayList arrayList6 : arrayList3) {
            DBIDs dBIDs = this.computeSubspace(arrayList6, arrayList2);
            double d = AggarwalYuNaive.sparsity(dBIDs.size(), n3, this.k, this.phi);
            if (!(d < 0.0)) continue;
            object = dBIDs.iter();
            while (object.valid()) {
                double d2 = object2.doubleValue((DBIDRef)object);
                if (Double.isNaN(d2) || d < d2) {
                    object2.putDouble((DBIDRef)object, d);
                }
                object.advance();
            }
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object3 = relation.iterDBIDs();
        while (object3.valid()) {
            double d = object2.doubleValue((DBIDRef)object3);
            if (Double.isNaN(d)) {
                object2.putDouble((DBIDRef)object3, 0.0);
                d = 0.0;
            }
            doubleMinMax.put(d);
            object3.advance();
        }
        object3 = new MaterializedDoubleRelation("AggarwalYuNaive", "aggarwal-yu-outlier", (DoubleDataStore)object2, relation.getDBIDs());
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), Double.NEGATIVE_INFINITY, 0.0);
        return new OutlierResult(invertedOutlierScoreMeta, (DoubleRelation)object3);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractAggarwalYuOutlier.Parameterizer {
        @Override
        protected AggarwalYuNaive<V> makeInstance() {
            return new AggarwalYuNaive(this.k, this.phi);
        }
    }
}

