/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.outlier.subspace.AbstractAggarwalYuOutlier;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

@Title(value="EAFOD: the evolutionary outlier detection algorithm")
@Description(value="Outlier detection for high dimensional data")
@Reference(authors="C.C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001), Santa Barbara, CA, 2001", url="http://dx.doi.org/10.1145/375663.375668")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.AggarwalYuEvolutionary"})
public class AggarwalYuEvolutionary<V extends NumberVector>
extends AbstractAggarwalYuOutlier<V> {
    private static final Logging LOG = Logging.getLogger(AggarwalYuEvolutionary.class);
    protected static final int MAX_ITERATIONS = 1000;
    protected static final double CONVERGENCE = 0.85;
    private int m;
    private RandomFactory rnd;

    public AggarwalYuEvolutionary(int n, int n2, int n3, RandomFactory randomFactory) {
        super(n, n2);
        this.m = n3;
        this.rnd = randomFactory;
    }

    public OutlierResult run(Database database, Relation<V> relation) {
        Object object;
        int n = relation.size();
        ArrayList<ArrayList<DBIDs>> arrayList = this.buildRanges(relation);
        Heap.UnorderedIter unorderedIter = new EvolutionarySearch(relation, arrayList, this.m, this.rnd.getSingleThreadedRandom()).run();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 6);
        while (unorderedIter.valid()) {
            object = this.computeSubspaceForGene(((Individuum)unorderedIter.get()).getGene(), arrayList);
            double d = AggarwalYuEvolutionary.sparsity(object.size(), n, this.k, this.phi);
            DBIDIter dBIDIter = object.iter();
            while (dBIDIter.valid()) {
                double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
                if (Double.isNaN(d2) || d < d2) {
                    writableDoubleDataStore.putDouble(dBIDIter, d);
                }
                dBIDIter.advance();
            }
            unorderedIter.advance();
        }
        object = new DoubleMinMax();
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            double d = writableDoubleDataStore.doubleValue((DBIDRef)object2);
            if (Double.isNaN(d)) {
                writableDoubleDataStore.putDouble((DBIDRef)object2, 0.0);
                d = 0.0;
            }
            ((DoubleMinMax)object).put(d);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("AggarwalYuEvolutionary", "aggarwal-yu-outlier", writableDoubleDataStore, relation.getDBIDs());
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), Double.NEGATIVE_INFINITY, 0.0);
        return new OutlierResult(invertedOutlierScoreMeta, (DoubleRelation)object2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractAggarwalYuOutlier.Parameterizer {
        public static final OptionID M_ID = new OptionID("ay.m", "Population size for evolutionary algorithm.");
        public static final OptionID SEED_ID = new OptionID("ay.seed", "The random number generator seed.");
        protected int m = 0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(M_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.m = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected AggarwalYuEvolutionary<V> makeInstance() {
            return new AggarwalYuEvolutionary(this.k, this.phi, this.m, this.rnd);
        }
    }

    private static class Individuum
    implements Comparable<Individuum> {
        double fitness;
        short[] gene;

        public Individuum(double d, short[] sArray) {
            this.fitness = d;
            this.gene = sArray;
        }

        public short[] getGene() {
            return this.gene;
        }

        public double getFitness() {
            return this.fitness;
        }

        public static Individuum nullIndividuum(int n) {
            short[] sArray = new short[n];
            Arrays.fill(sArray, (short)-1);
            return new Individuum(0.0, sArray);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("I(f=").append(this.fitness);
            stringBuilder.append(",g=");
            for (int i = 0; i < this.gene.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                if (this.gene[i] == -1) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append(this.gene[i]);
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Individuum)) {
                return false;
            }
            Individuum individuum = (Individuum)object;
            if (individuum.gene.length != this.gene.length) {
                return false;
            }
            for (int i = 0; i < this.gene.length; ++i) {
                if (individuum.gene[i] == this.gene[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(Individuum individuum) {
            return Double.compare(this.fitness, individuum.fitness);
        }
    }

    private class EvolutionarySearch {
        final int dbsize;
        final int dim;
        final ArrayList<ArrayList<DBIDs>> ranges;
        final int m;
        private final Random random;

        public EvolutionarySearch(Relation<V> relation, ArrayList<ArrayList<DBIDs>> arrayList, int n, Random random) {
            this.ranges = arrayList;
            this.m = n;
            this.dbsize = relation.size();
            this.dim = RelationUtil.dimensionality(relation);
            this.random = random;
        }

        public Heap.UnorderedIter run() {
            ArrayList<Individuum> arrayList = this.initialPopulation(this.m);
            TopBoundedHeap topBoundedHeap = new TopBoundedHeap(this.m, Collections.reverseOrder());
            for (Individuum individuum : arrayList) {
                topBoundedHeap.add(individuum);
            }
            IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Evolutionary search iterations", LOG) : null;
            int n = 0;
            while (!this.checkConvergence(arrayList)) {
                Collections.sort(arrayList);
                arrayList = this.rouletteRankSelection(arrayList);
                arrayList = this.crossoverOptimized(arrayList);
                arrayList = this.mutation(arrayList, 0.25, 0.25);
                block2: for (Individuum individuum : arrayList) {
                    Object object = topBoundedHeap.unorderedIter();
                    while (((Heap.UnorderedIter)object).valid()) {
                        if (((Individuum)((Heap.UnorderedIter)object).get()).equals(individuum)) continue block2;
                        ((Heap.UnorderedIter)object).advance();
                    }
                    topBoundedHeap.add(individuum);
                }
                if (LOG.isDebuggingFinest()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Top solutions:\n");
                    Heap.UnorderedIter unorderedIter = topBoundedHeap.unorderedIter();
                    while (unorderedIter.valid()) {
                        stringBuilder.append(((Individuum)unorderedIter.get()).toString()).append('\n');
                        unorderedIter.advance();
                    }
                    stringBuilder.append("Population:\n");
                    for (Object object : arrayList) {
                        stringBuilder.append(((Individuum)object).toString()).append('\n');
                    }
                    LOG.debugFinest(stringBuilder.toString());
                }
                LOG.incrementProcessed(indefiniteProgress);
                if (++n <= 1000) continue;
                LOG.warning("Maximum iterations reached.");
                break;
            }
            if (indefiniteProgress != null) {
                indefiniteProgress.setCompleted(LOG);
            }
            return topBoundedHeap.unorderedIter();
        }

        private boolean checkConvergence(Collection<Individuum> collection) {
            int n;
            if (collection.size() == 0) {
                return true;
            }
            int[][] nArray = new int[this.dim][AggarwalYuEvolutionary.this.phi + 1];
            for (Individuum individuum : collection) {
                short[] sArray = individuum.getGene();
                for (n = 0; n < this.dim; ++n) {
                    if (sArray[n] == -1) {
                        int[] nArray2 = nArray[n];
                        nArray2[0] = nArray2[0] + 1;
                        continue;
                    }
                    int n2 = sArray[n] - 0;
                    if (n2 < 0 || n2 >= AggarwalYuEvolutionary.this.phi) {
                        LOG.warning("Invalid gene value encountered: " + n2 + " in " + individuum.toString());
                        continue;
                    }
                    int[] nArray3 = nArray[n];
                    int n3 = n2 + 1;
                    nArray3[n3] = nArray3[n3] + 1;
                }
            }
            int n4 = (int)Math.floor((double)collection.size() * 0.85);
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Convergence at " + n4 + " of " + collection.size() + " individuums.");
            }
            for (int i = 0; i < this.dim; ++i) {
                boolean bl = false;
                for (n = 0; n <= AggarwalYuEvolutionary.this.phi; ++n) {
                    if (nArray[i][n] < n4) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        private ArrayList<Individuum> initialPopulation(int n) {
            ArrayList<Individuum> arrayList = new ArrayList<Individuum>(n);
            for (int i = 0; i < n; ++i) {
                short[] sArray = new short[this.dim];
                Arrays.fill(sArray, (short)-1);
                int n2 = AggarwalYuEvolutionary.this.k;
                while (n2 > 0) {
                    int n3 = this.random.nextInt(this.dim);
                    if (sArray[n3] != -1) continue;
                    sArray[n3] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                    --n2;
                }
                arrayList.add(this.makeIndividuum(sArray));
            }
            return arrayList;
        }

        private ArrayList<Individuum> rouletteRankSelection(ArrayList<Individuum> arrayList) {
            int n = arrayList.size();
            int n2 = n * (n + 1) >> 1;
            ArrayList<Individuum> arrayList2 = new ArrayList<Individuum>(n);
            block0: for (int i = 0; i < n; ++i) {
                int n3 = this.random.nextInt(n2);
                int n4 = 0;
                int n5 = n;
                while (n4 < n) {
                    if (n3 < n5) {
                        arrayList2.add(arrayList.get(n4));
                        continue block0;
                    }
                    n3 -= n5;
                    ++n4;
                    --n5;
                }
            }
            assert (arrayList2.size() == n) : "Selection step failed - implementation error?";
            return arrayList2;
        }

        private ArrayList<Individuum> mutation(ArrayList<Individuum> arrayList, double d, double d2) {
            ArrayList<Individuum> arrayList2 = new ArrayList<Individuum>();
            int[] nArray = new int[this.dim];
            for (int i = 0; i < arrayList.size(); ++i) {
                short[] sArray = (short[])arrayList.get(i).getGene().clone();
                int n = 0;
                int n2 = this.dim;
                int n3 = 0;
                while (n3 < this.dim) {
                    nArray[sArray[n3] == -1 ? n++ : --n2] = n3++;
                }
                if (n > 0 && n2 < this.dim && this.random.nextDouble() <= d) {
                    n3 = this.random.nextInt(n);
                    int n4 = this.random.nextInt(this.dim - n2) + n2;
                    int n5 = nArray[n3];
                    int n6 = nArray[n4];
                    sArray[n5] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                    sArray[n6] = -1;
                    nArray[n3] = n6;
                    nArray[n4] = n5;
                }
                if (this.random.nextDouble() <= d2) {
                    n3 = this.random.nextInt(this.dim - n2) + n2;
                    sArray[nArray[n3]] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                }
                arrayList2.add(this.makeIndividuum(sArray));
            }
            return arrayList2;
        }

        private Individuum makeIndividuum(short[] sArray) {
            DBIDs dBIDs = AggarwalYuEvolutionary.this.computeSubspaceForGene(sArray, this.ranges);
            double d = dBIDs.size() > 0 ? AbstractAggarwalYuOutlier.sparsity(dBIDs.size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi) : Double.MAX_VALUE;
            return new Individuum(d, sArray);
        }

        private ArrayList<Individuum> crossoverOptimized(ArrayList<Individuum> arrayList) {
            ArrayList<Individuum> arrayList2 = new ArrayList<Individuum>();
            for (int i = 0; i < arrayList.size() - 1; i += 2) {
                Pair<Individuum, Individuum> pair = this.recombineOptimized(arrayList.get(i), arrayList.get(i + 1));
                arrayList2.add(pair.getFirst());
                arrayList2.add(pair.getSecond());
            }
            if (arrayList.size() % 2 == 1) {
                arrayList2.add(arrayList.get(arrayList.size() - 1));
            }
            return arrayList2;
        }

        private Pair<Individuum, Individuum> recombineOptimized(Individuum individuum, Individuum individuum2) {
            short[] sArray;
            TIntArrayList tIntArrayList = new TIntArrayList(this.dim);
            TIntArrayList tIntArrayList2 = new TIntArrayList(this.dim);
            for (int i = 0; i < this.dim; ++i) {
                if (individuum.getGene()[i] == -1 && individuum2.getGene()[i] != -1) {
                    tIntArrayList.add(i);
                }
                if (individuum.getGene()[i] != -1 && individuum2.getGene()[i] == -1) {
                    tIntArrayList.add(i);
                }
                if (individuum.getGene()[i] == -1 || individuum2.getGene()[i] == -1) continue;
                tIntArrayList2.add(i);
            }
            Individuum individuum3 = this.combineRecursive(tIntArrayList2, 0, Individuum.nullIndividuum(this.dim).getGene(), individuum, individuum2);
            short[] sArray2 = individuum3.getGene();
            int n = AggarwalYuEvolutionary.this.k - tIntArrayList2.size();
            TIntIterator tIntIterator = tIntArrayList.iterator();
            while (n > 0) {
                sArray = (short[])sArray2.clone();
                short[] sArray3 = (short[])sArray2.clone();
                while (tIntIterator.hasNext()) {
                    double d;
                    int n2 = tIntIterator.next();
                    boolean bl = individuum.getGene()[n2] == -1;
                    boolean bl2 = individuum.getGene()[n2] == -1;
                    sArray[n2] = individuum.getGene()[n2];
                    sArray3[n2] = individuum2.getGene()[n2];
                    double d2 = AbstractAggarwalYuOutlier.sparsity(AggarwalYuEvolutionary.this.computeSubspaceForGene(sArray, this.ranges).size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi);
                    if (d2 <= (d = AbstractAggarwalYuOutlier.sparsity(AggarwalYuEvolutionary.this.computeSubspaceForGene(sArray3, this.ranges).size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi))) {
                        sArray2 = (short[])sArray.clone();
                        if (!bl) continue;
                        --n;
                        continue;
                    }
                    sArray2 = (short[])sArray3.clone();
                    if (!bl2) continue;
                    --n;
                }
            }
            sArray = new short[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                sArray[i] = sArray2[i] == individuum.getGene()[i] ? individuum2.getGene()[i] : individuum2.getGene()[i];
            }
            Individuum individuum4 = this.makeIndividuum(sArray2);
            Individuum individuum5 = this.makeIndividuum(sArray);
            Pair<Individuum, Individuum> pair = new Pair<Individuum, Individuum>(individuum4, individuum5);
            return pair;
        }

        private Individuum combineRecursive(TIntArrayList tIntArrayList, int n, short[] sArray, Individuum individuum, Individuum individuum2) {
            if (n == tIntArrayList.size()) {
                return this.makeIndividuum(sArray);
            }
            int n2 = tIntArrayList.get(n);
            short[] sArray2 = (short[])sArray.clone();
            short[] sArray3 = sArray;
            sArray2[n2] = individuum.getGene()[n2];
            sArray3[n2] = individuum2.getGene()[n2];
            Individuum individuum3 = this.combineRecursive(tIntArrayList, n + 1, sArray2, individuum, individuum2);
            Individuum individuum4 = this.combineRecursive(tIntArrayList, n + 1, sArray3, individuum, individuum2);
            return individuum3.getFitness() < individuum4.getFitness() ? individuum3 : individuum4;
        }
    }
}

