/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class LinearWeightedExtendedNeighborhood
implements WeightedNeighborSetPredicate {
    private NeighborSetPredicate inner;
    private int steps;

    public LinearWeightedExtendedNeighborhood(NeighborSetPredicate neighborSetPredicate, int n) {
        this.inner = neighborSetPredicate;
        this.steps = n;
    }

    private double computeWeight(int n) {
        return 1.0 - (double)((float)n / (float)(this.steps + 1));
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef dBIDRef) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        ArrayList<DoubleDBIDPair> arrayList = new ArrayList<DoubleDBIDPair>();
        arrayList.add(DBIDUtil.newPair(this.computeWeight(0), dBIDRef));
        hashSetModifiableDBIDs.add(dBIDRef);
        SetDBIDs setDBIDs = DBIDUtil.deref(dBIDRef);
        for (int i = 1; i <= this.steps; ++i) {
            double d = this.computeWeight(i);
            HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet();
            DBIDIter dBIDIter = setDBIDs.iter();
            while (dBIDIter.valid()) {
                DBIDIter dBIDIter2 = this.inner.getNeighborDBIDs(dBIDIter).iter();
                while (dBIDIter2.valid()) {
                    if (!hashSetModifiableDBIDs.contains(dBIDIter2)) {
                        hashSetModifiableDBIDs2.add(dBIDIter2);
                        arrayList.add(DBIDUtil.newPair(d, (DBIDRef)dBIDIter2));
                    }
                    dBIDIter2.advance();
                }
                dBIDIter.advance();
            }
            if (hashSetModifiableDBIDs2.size() == 0) break;
            setDBIDs = hashSetModifiableDBIDs2;
        }
        return arrayList;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> factory, int n) {
            this.inner = factory;
            this.steps = n;
        }

        @Override
        public LinearWeightedExtendedNeighborhood instantiate(Database database, Relation<? extends O> relation) {
            return new LinearWeightedExtendedNeighborhood(this.inner.instantiate(database, relation), this.steps);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            protected static <O> NeighborSetPredicate.Factory<O> getParameterInnerNeighborhood(Parameterization parameterization) {
                ObjectParameter objectParameter = new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class);
                if (parameterization.grab(objectParameter)) {
                    return (NeighborSetPredicate.Factory)objectParameter.instantiateClass(parameterization);
                }
                return null;
            }

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                this.inner = Parameterizer.getParameterInnerNeighborhood(parameterization);
                this.steps = Parameterizer.getParameterSteps(parameterization);
            }

            public static int getParameterSteps(Parameterization parameterization) {
                IntParameter intParameter = new IntParameter(STEPS_ID);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    return (Integer)intParameter.getValue();
                }
                return 1;
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

