/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="SLOM: a new measure for local spatial outliers")
@Description(value="Spatial local outlier measure (SLOM), which captures the local behaviour of datum in their spatial neighbourhood")
@Reference(authors="Sanjay Chawla and Pei Sun", title="SLOM: a new measure for local spatial outliers", booktitle="Knowledge and Information Systems 9(4), 412-429, 2006", url="http://dx.doi.org/10.1007/s10115-005-0200-2")
public class SLOM<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    private static final Logging LOG = Logging.getLogger(SLOM.class);

    public SLOM(NeighborSetPredicate.Factory<N> factory, PrimitiveDistanceFunction<O> primitiveDistanceFunction) {
        super(factory, primitiveDistanceFunction);
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<O> relation2) {
        DBIDs dBIDs;
        int n;
        double d;
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        DistanceQuery<O> distanceQuery = this.getNonSpatialDistanceFunction().instantiate(relation2);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 3);
        Object object = relation2.iterDBIDs();
        while (object.valid()) {
            double d2 = 0.0;
            d = 0.0;
            n = 0;
            dBIDs = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object);
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object, dBIDIter)) {
                    double d3 = distanceQuery.distance((DBIDRef)object, (DBIDRef)dBIDIter);
                    d2 += d3;
                    ++n;
                    d = Math.max(d, d3);
                }
                dBIDIter.advance();
            }
            if (n > 1) {
                writableDoubleDataStore.putDouble((DBIDRef)object, (d2 - d) / (double)(n - 1));
            } else {
                writableDoubleDataStore.putDouble((DBIDRef)object, d);
            }
            object.advance();
        }
        object = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        Object object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            double d4;
            d = 0.0;
            n = 0;
            dBIDs = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2);
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, dBIDIter)) {
                    d += writableDoubleDataStore.doubleValue(dBIDIter);
                    ++n;
                }
                dBIDIter.advance();
            }
            if (n > 0) {
                double d5 = (d + writableDoubleDataStore.doubleValue((DBIDRef)object2)) / (double)(n + 1);
                double d6 = d / (double)n;
                double d7 = 0.0;
                DBIDIter dBIDIter2 = dBIDs.iter();
                while (dBIDIter2.valid()) {
                    double d8 = writableDoubleDataStore.doubleValue(dBIDIter2);
                    if (d8 > d5) {
                        d7 += 1.0;
                    } else if (d8 < d5) {
                        d7 -= 1.0;
                    }
                    dBIDIter2.advance();
                }
                if (!dBIDs.contains((DBIDRef)object2)) {
                    double d9 = writableDoubleDataStore.doubleValue((DBIDRef)object2);
                    if (d9 > d5) {
                        d7 += 1.0;
                    } else if (d9 < d5) {
                        d7 -= 1.0;
                    }
                }
                d7 = Math.abs(d7);
                d7 = n > 1 ? Math.max(d7, 1.0) / (double)(n - 1) : 1.0;
                d4 = (d7 /= 1.0 + d6) * writableDoubleDataStore.doubleValue((DBIDRef)object2);
            } else {
                d4 = 0.0;
            }
            writableDoubleDataStore2.putDouble((DBIDRef)object2, d4);
            ((DoubleMinMax)object).put(d4);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("SLOM", "slom-outlier", writableDoubleDataStore2, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object2);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Parameterizer<N, O> {
        @Override
        protected SLOM<N, O> makeInstance() {
            return new SLOM(this.npredf, this.distanceFunction);
        }
    }
}

