/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.projection.NumericalFeatureSelection;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProjectedView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

@Title(value="HiCS: High Contrast Subspaces for Density-Based Outlier Ranking")
@Description(value="Algorithm to compute High Contrast Subspaces in a database as a pre-processing step for for density-based outlier ranking methods.")
@Reference(authors="Fabian Keller, Emmanuel M\u00fcller, Klemens B\u00f6hm", title="HiCS: High Contrast Subspaces for Density-Based Outlier Ranking", booktitle="Proc. IEEE 28th International Conference on Data Engineering (ICDE 2012)", url="http://dx.doi.org/10.1109/ICDE.2012.88")
public class HiCS<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(HiCS.class);
    private static final int MAX_RETRIES = 100;
    private int m;
    private double alpha;
    private OutlierAlgorithm outlierAlgorithm;
    private GoodnessOfFitTest statTest;
    private int cutoff;
    private RandomFactory rnd;

    public HiCS(int n, double d, OutlierAlgorithm outlierAlgorithm, GoodnessOfFitTest goodnessOfFitTest, int n2, RandomFactory randomFactory) {
        this.m = n;
        this.alpha = d;
        this.outlierAlgorithm = outlierAlgorithm;
        this.statTest = goodnessOfFitTest;
        this.cutoff = n2;
        this.rnd = randomFactory;
    }

    public OutlierResult run(Relation<V> relation) {
        Object object;
        DBIDs dBIDs = relation.getDBIDs();
        ArrayList<ArrayDBIDs> arrayList = this.buildOneDimIndexes(relation);
        Set<HiCSSubspace> set = this.calculateSubspaces(relation, arrayList, this.rnd.getSingleThreadedRandom());
        if (LOG.isVerbose()) {
            LOG.verbose("Number of high-contrast subspaces: " + set.size());
        }
        ArrayList<DoubleRelation> arrayList2 = new ArrayList<DoubleRelation>();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Calculating Outlier scores for high Contrast subspaces", set.size(), LOG) : null;
        for (HiCSSubspace object22 : set) {
            if (LOG.isVerbose()) {
                LOG.verbose("Performing outlier detection in subspace " + object22);
            }
            object = new ProxyDatabase(dBIDs);
            ((ProxyDatabase)object).addRelation(new ProjectedView(relation, new NumericalFeatureSelection(object22)));
            OutlierResult d = this.outlierAlgorithm.run((Database)object);
            arrayList2.add(d.getScores());
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        object = relation.iterDBIDs();
        while (object.valid()) {
            double materializedDoubleRelation = 0.0;
            for (DoubleRelation doubleRelation : arrayList2) {
                double d = doubleRelation.doubleValue((DBIDRef)object);
                if (Double.isNaN(d)) continue;
                materializedDoubleRelation += d;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object, materializedDoubleRelation);
            doubleMinMax.put(materializedDoubleRelation);
            object.advance();
        }
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("HiCS", "HiCS-outlier", writableDoubleDataStore, relation.getDBIDs());
        return new OutlierResult((OutlierScoreMeta)object, materializedDoubleRelation);
    }

    private ArrayList<ArrayDBIDs> buildOneDimIndexes(Relation<? extends NumberVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        ArrayList<ArrayDBIDs> arrayList = new ArrayList<ArrayDBIDs>(n + 1);
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation);
        for (int i = 0; i < n; ++i) {
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
            sortDBIDsBySingleDimension.setDimension(i);
            arrayModifiableDBIDs.sort(sortDBIDsBySingleDimension);
            arrayList.add(arrayModifiableDBIDs);
        }
        return arrayList;
    }

    private Set<HiCSSubspace> calculateSubspaces(Relation<? extends NumberVector> relation, ArrayList<ArrayDBIDs> arrayList, Random random) {
        Cloneable cloneable;
        int n;
        FiniteProgress finiteProgress;
        int n2 = RelationUtil.dimensionality(relation);
        FiniteProgress finiteProgress2 = finiteProgress = LOG.isVerbose() ? new FiniteProgress("Subspace dimensionality", n2, LOG) : null;
        if (finiteProgress != null) {
            finiteProgress.setProcessed(2, LOG);
        }
        TreeSet<HiCSSubspace> treeSet = new TreeSet<HiCSSubspace>(HiCSSubspace.SORT_BY_SUBSPACE);
        TopBoundedHeap<HiCSSubspace> topBoundedHeap = new TopBoundedHeap<HiCSSubspace>(this.cutoff, HiCSSubspace.SORT_BY_CONTRAST_ASC);
        FiniteProgress finiteProgress3 = LOG.isVerbose() ? new FiniteProgress("Generating two-element subsets", n2 * (n2 - 1) >> 1, LOG) : null;
        for (int i = 0; i < n2; ++i) {
            for (n = i + 1; n < n2; ++n) {
                cloneable = new HiCSSubspace();
                ((BitSet)cloneable).set(i);
                ((BitSet)cloneable).set(n);
                this.calculateContrast(relation, (HiCSSubspace)cloneable, arrayList, random);
                topBoundedHeap.add((HiCSSubspace)cloneable);
                LOG.incrementProcessed(finiteProgress3);
            }
        }
        LOG.ensureCompleted(finiteProgress3);
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Testing subspace candidates", LOG) : null;
        n = 3;
        while (!topBoundedHeap.isEmpty()) {
            Object object;
            if (finiteProgress != null) {
                finiteProgress.setProcessed(n, LOG);
            }
            cloneable = new ArrayList(topBoundedHeap.size());
            Object object2 = topBoundedHeap.unorderedIter();
            while (((Heap.UnorderedIter)object2).valid()) {
                treeSet.add((HiCSSubspace)((Heap.UnorderedIter)object2).get());
                ((ArrayList)cloneable).add(((Heap.UnorderedIter)object2).get());
                ((Heap.UnorderedIter)object2).advance();
            }
            topBoundedHeap.clear();
            Collections.sort(cloneable, HiCSSubspace.SORT_BY_SUBSPACE);
            for (int i = 0; i < ((ArrayList)cloneable).size() - 1; ++i) {
                for (int j = i + 1; j < ((ArrayList)cloneable).size(); ++j) {
                    object = (HiCSSubspace)((ArrayList)cloneable).get(i);
                    HiCSSubspace hiCSSubspace = (HiCSSubspace)((ArrayList)cloneable).get(j);
                    HiCSSubspace hiCSSubspace2 = new HiCSSubspace();
                    hiCSSubspace2.or((BitSet)object);
                    hiCSSubspace2.or(hiCSSubspace);
                    if (hiCSSubspace2.cardinality() != n) continue;
                    this.calculateContrast(relation, hiCSSubspace2, arrayList, random);
                    topBoundedHeap.add(hiCSSubspace2);
                    LOG.incrementProcessed(indefiniteProgress);
                }
            }
            object2 = ((ArrayList)cloneable).iterator();
            block6: while (object2.hasNext()) {
                HiCSSubspace hiCSSubspace = (HiCSSubspace)object2.next();
                object = topBoundedHeap.unorderedIter();
                while (((Heap.UnorderedIter)object).valid()) {
                    if (((HiCSSubspace)((Heap.UnorderedIter)object).get()).contrast > hiCSSubspace.contrast) {
                        treeSet.remove(hiCSSubspace);
                        continue block6;
                    }
                    ((Heap.UnorderedIter)object).advance();
                }
            }
            ++n;
        }
        LOG.setCompleted(indefiniteProgress);
        if (finiteProgress != null) {
            finiteProgress.setProcessed(n2, LOG);
            finiteProgress.ensureCompleted(LOG);
        }
        return treeSet;
    }

    private void calculateContrast(Relation<? extends NumberVector> relation, HiCSSubspace hiCSSubspace, ArrayList<ArrayDBIDs> arrayList, Random random) {
        int n = hiCSSubspace.cardinality();
        double d = Math.pow(this.alpha, 1.0 / (double)n);
        int n2 = (int)((double)relation.size() * d);
        FiniteProgress finiteProgress = LOG.isDebugging() ? new FiniteProgress("Monte-Carlo iterations", this.m, LOG) : null;
        int n3 = 0;
        double d2 = 0.0;
        for (int i = 0; i < this.m; ++i) {
            DBIDArrayIter dBIDArrayIter;
            Object object;
            Object object2;
            int n4 = -1;
            for (int j = random.nextInt(n); j >= 0; --j) {
                n4 = hiCSSubspace.nextSetBit(n4 + 1);
            }
            DBIDs dBIDs = relation.getDBIDs();
            int n5 = hiCSSubspace.nextSetBit(0);
            while (n5 >= 0) {
                if (n5 != n4) {
                    object2 = arrayList.get(n5);
                    object = DBIDUtil.newArray(n2);
                    dBIDArrayIter = object2.iter();
                    dBIDArrayIter.seek(random.nextInt(relation.size() - n2));
                    for (int j = 0; j < n2; ++j) {
                        object.add(dBIDArrayIter);
                        dBIDArrayIter.advance();
                    }
                    dBIDs = DBIDUtil.intersection(dBIDs, (DBIDs)object);
                }
                n5 = hiCSSubspace.nextSetBit(n5 + 1);
            }
            if (dBIDs.size() < 10) {
                ++n3;
                if (LOG.isDebugging()) {
                    LOG.debug("Sample size very small. Retry no. " + n3);
                }
                if (n3 >= 100) {
                    LOG.warning("Too many retries, for small samples: " + n3);
                } else {
                    --i;
                    continue;
                }
            }
            double[] dArray = new double[dBIDs.size()];
            int n6 = 0;
            object = dBIDs.iter();
            while (object.valid()) {
                dArray[n6] = relation.get((DBIDRef)object).doubleValue(n4);
                ++n6;
                object.advance();
            }
            object2 = new double[relation.size()];
            int n7 = 0;
            dBIDArrayIter = arrayList.get(n4).iter();
            while (dBIDArrayIter.valid()) {
                object2[n7] = relation.get(dBIDArrayIter).doubleValue(n4);
                ++n7;
                dBIDArrayIter.advance();
            }
            double d3 = this.statTest.deviation((double[])object2, dArray);
            if (Double.isNaN(d3)) {
                --i;
                LOG.warning("Contrast was NaN");
                continue;
            }
            d2 += d3;
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        hiCSSubspace.contrast = d2 / (double)this.m;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID M_ID = new OptionID("hics.m", "The number of iterations in the Monte-Carlo processing.");
        public static final OptionID ALPHA_ID = new OptionID("hics.alpha", "The discriminance value that determines the size of the test statistic .");
        public static final OptionID ALGO_ID = new OptionID("hics.algo", "The Algorithm that performs the actual outlier detection on the resulting set of subspace");
        public static final OptionID TEST_ID = new OptionID("hics.test", "The statistical test that is used to calculate the deviation of two data samples");
        public static final OptionID LIMIT_ID = new OptionID("hics.limit", "The threshold that determines how many d-dimensional subspace candidates to retain in each step of the generation");
        public static final OptionID SEED_ID = new OptionID("hics.seed", "The random seed.");
        private int m = 50;
        private double alpha = 0.1;
        private OutlierAlgorithm outlierAlgorithm;
        private GoodnessOfFitTest statTest;
        private int cutoff = 400;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            ObjectParameter objectParameter;
            ObjectParameter objectParameter2;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(M_ID, 50);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.m = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.1);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            if (parameterization.grab(objectParameter2 = new ObjectParameter(ALGO_ID, (Class<?>)OutlierAlgorithm.class, LOF.class))) {
                this.outlierAlgorithm = (OutlierAlgorithm)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(TEST_ID, (Class<?>)GoodnessOfFitTest.class, KolmogorovSmirnovTest.class))) {
                this.statTest = (GoodnessOfFitTest)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter2 = new IntParameter(LIMIT_ID, 100);
            intParameter2.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.cutoff = intParameter2.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected HiCS<V> makeInstance() {
            return new HiCS(this.m, this.alpha, this.outlierAlgorithm, this.statTest, this.cutoff, this.rnd);
        }
    }

    public static class HiCSSubspace
    extends BitSet {
        private static final long serialVersionUID = 1L;
        protected double contrast;
        public static final Comparator<HiCSSubspace> SORT_BY_CONTRAST_ASC = new Comparator<HiCSSubspace>(){

            @Override
            public int compare(HiCSSubspace hiCSSubspace, HiCSSubspace hiCSSubspace2) {
                if (hiCSSubspace.contrast == hiCSSubspace2.contrast) {
                    return 0;
                }
                return hiCSSubspace.contrast > hiCSSubspace2.contrast ? 1 : -1;
            }
        };
        public static final Comparator<HiCSSubspace> SORT_BY_CONTRAST_DESC = new Comparator<HiCSSubspace>(){

            @Override
            public int compare(HiCSSubspace hiCSSubspace, HiCSSubspace hiCSSubspace2) {
                if (hiCSSubspace.contrast == hiCSSubspace2.contrast) {
                    return 0;
                }
                return hiCSSubspace.contrast < hiCSSubspace2.contrast ? 1 : -1;
            }
        };
        public static final Comparator<HiCSSubspace> SORT_BY_SUBSPACE = new Comparator<HiCSSubspace>(){

            @Override
            public int compare(HiCSSubspace hiCSSubspace, HiCSSubspace hiCSSubspace2) {
                int n = hiCSSubspace.nextSetBit(0);
                int n2 = hiCSSubspace2.nextSetBit(0);
                while (n >= 0 && n2 >= 0) {
                    if (n < n2) {
                        return -1;
                    }
                    if (n > n2) {
                        return 1;
                    }
                    n = hiCSSubspace.nextSetBit(n + 1);
                    n2 = hiCSSubspace2.nextSetBit(n2 + 1);
                }
                return 0;
            }
        };

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[contrast=").append(this.contrast);
            int n = this.nextSetBit(0);
            while (n >= 0) {
                stringBuilder.append(' ').append(n + 1);
                n = this.nextSetBit(n + 1);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

