/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.FlexibleLOF;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNChangeEvent;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNListener;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.OnlineLOF"})
public class OnlineLOF<O>
extends FlexibleLOF<O> {
    private static final Logging LOG = Logging.getLogger(OnlineLOF.class);

    public OnlineLOF(int n, int n2, DistanceFunction<? super O> distanceFunction, DistanceFunction<? super O> distanceFunction2) {
        super(n, n2, distanceFunction, distanceFunction2);
    }

    @Override
    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("OnlineLOF", 3) : null;
        Pair<Pair<KNNQuery<O>, KNNQuery<O>>, Pair<RKNNQuery<O>, RKNNQuery<O>>> pair = this.getKNNAndRkNNQueries(database, relation, stepProgress);
        KNNQuery<O> kNNQuery = pair.getFirst().getFirst();
        KNNQuery<O> kNNQuery2 = pair.getFirst().getSecond();
        RKNNQuery<O> rKNNQuery = pair.getSecond().getFirst();
        RKNNQuery<O> rKNNQuery2 = pair.getSecond().getSecond();
        FlexibleLOF.LOFResult<O> lOFResult = super.doRunInTime(relation.getDBIDs(), kNNQuery, kNNQuery2, stepProgress);
        lOFResult.setRkNNRefer(rKNNQuery);
        lOFResult.setRkNNReach(rKNNQuery2);
        LOFKNNListener lOFKNNListener = new LOFKNNListener(lOFResult);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lOFResult.getKNNRefer()).getPreprocessor()).addKNNListener(lOFKNNListener);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lOFResult.getKNNReach()).getPreprocessor()).addKNNListener(lOFKNNListener);
        return lOFResult.getResult();
    }

    private Pair<Pair<KNNQuery<O>, KNNQuery<O>>, Pair<RKNNQuery<O>, RKNNQuery<O>>> getKNNAndRkNNQueries(Database database, Relation<O> relation, StepProgress stepProgress) {
        Object object;
        Object object2;
        Object object3;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.referenceDistanceFunction, new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.krefer, "heavy", "optimized", "no-cache");
        RKNNQuery<O> rKNNQuery = database.getRKNNQuery(distanceQuery, "heavy", "optimized", "no-cache");
        if (kNNQuery == null || rKNNQuery == null) {
            if (stepProgress != null) {
                stepProgress.beginStep(1, "Materializing neighborhood w.r.t. reference neighborhood distance function.", LOG);
            }
            object3 = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.referenceDistanceFunction, this.krefer);
            kNNQuery = ((AbstractMaterializeKNNPreprocessor)object3).getKNNQuery(distanceQuery, this.krefer, "heavy");
            rKNNQuery = ((MaterializeKNNAndRKNNPreprocessor)object3).getRKNNQuery(distanceQuery, this.krefer, "heavy");
            database.getHierarchy().add(relation, (Result)object3);
        } else if (stepProgress != null) {
            stepProgress.beginStep(1, "Optimized neighborhood w.r.t. reference neighborhood distance function provided by database.", LOG);
        }
        object3 = database.getDistanceQuery(relation, this.reachabilityDistanceFunction, new Object[0]);
        KNNQuery kNNQuery2 = database.getKNNQuery(object3, new Object[]{this.kreach, "heavy", "optimized", "no-cache"});
        RKNNQuery rKNNQuery2 = database.getRKNNQuery(object3, new Object[]{"heavy", "optimized", "no-cache"});
        if (kNNQuery2 == null || rKNNQuery2 == null) {
            if (stepProgress != null) {
                stepProgress.beginStep(2, "Materializing neighborhood w.r.t. reachability distance function.", LOG);
            }
            object2 = new ListParameterization();
            ((ListParameterization)object2).addParameter(AbstractMaterializeKNNPreprocessor.Factory.DISTANCE_FUNCTION_ID, this.reachabilityDistanceFunction);
            ((ListParameterization)object2).addParameter(AbstractMaterializeKNNPreprocessor.Factory.K_ID, this.kreach);
            object = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.reachabilityDistanceFunction, this.kreach);
            kNNQuery2 = ((AbstractMaterializeKNNPreprocessor)object).getKNNQuery(object3, new Object[]{this.kreach, "heavy"});
            rKNNQuery2 = ((MaterializeKNNAndRKNNPreprocessor)object).getRKNNQuery(object3, new Object[]{this.kreach, "heavy"});
            database.getHierarchy().add(relation, (Result)object);
        }
        object2 = new Pair(kNNQuery, kNNQuery2);
        object = new Pair(rKNNQuery, rKNNQuery2);
        return new Pair(object2, object);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends FlexibleLOF.Parameterizer<O> {
        @Override
        protected OnlineLOF<O> makeInstance() {
            return new OnlineLOF(this.kreach, this.krefer, this.distanceFunction, this.reachabilityDistanceFunction);
        }
    }

    private class LOFKNNListener
    implements KNNListener {
        private KNNChangeEvent firstEventReceived;
        private FlexibleLOF.LOFResult<O> lofResult;

        public LOFKNNListener(FlexibleLOF.LOFResult<O> lOFResult) {
            this.lofResult = lOFResult;
        }

        @Override
        public void kNNsChanged(KNNChangeEvent kNNChangeEvent) {
            AbstractMaterializeKNNPreprocessor abstractMaterializeKNNPreprocessor = ((PreprocessorKNNQuery)this.lofResult.getKNNRefer()).getPreprocessor();
            AbstractMaterializeKNNPreprocessor abstractMaterializeKNNPreprocessor2 = ((PreprocessorKNNQuery)this.lofResult.getKNNReach()).getPreprocessor();
            if (this.firstEventReceived == null) {
                if (kNNChangeEvent.getSource().equals(abstractMaterializeKNNPreprocessor) && kNNChangeEvent.getSource().equals(abstractMaterializeKNNPreprocessor2)) {
                    this.kNNsChanged(kNNChangeEvent, kNNChangeEvent);
                } else {
                    this.firstEventReceived = kNNChangeEvent;
                }
            } else if (kNNChangeEvent.getSource().equals(abstractMaterializeKNNPreprocessor) && this.firstEventReceived.getSource().equals(abstractMaterializeKNNPreprocessor2)) {
                this.kNNsChanged(kNNChangeEvent, this.firstEventReceived);
                this.firstEventReceived = null;
            } else if (kNNChangeEvent.getSource().equals(abstractMaterializeKNNPreprocessor2) && this.firstEventReceived.getSource().equals(abstractMaterializeKNNPreprocessor)) {
                this.kNNsChanged(this.firstEventReceived, kNNChangeEvent);
                this.firstEventReceived = null;
            } else {
                throw new UnsupportedOperationException("Event sources do not fit!");
            }
        }

        private void kNNsChanged(KNNChangeEvent kNNChangeEvent, KNNChangeEvent kNNChangeEvent2) {
            if (!kNNChangeEvent.getType().equals((Object)kNNChangeEvent2.getType())) {
                throw new UnsupportedOperationException("Event types do not fit: " + (Object)((Object)kNNChangeEvent.getType()) + " != " + (Object)((Object)kNNChangeEvent2.getType()));
            }
            if (!kNNChangeEvent.getObjects().equals(kNNChangeEvent2.getObjects())) {
                throw new UnsupportedOperationException("Objects do not fit: " + kNNChangeEvent.getObjects() + " != " + kNNChangeEvent2.getObjects());
            }
            if (kNNChangeEvent.getType().equals((Object)KNNChangeEvent.Type.DELETE)) {
                this.kNNsRemoved(kNNChangeEvent.getObjects(), kNNChangeEvent.getUpdates(), kNNChangeEvent2.getUpdates(), this.lofResult);
            } else if (kNNChangeEvent.getType().equals((Object)KNNChangeEvent.Type.INSERT)) {
                this.kNNsInserted(kNNChangeEvent.getObjects(), kNNChangeEvent.getUpdates(), kNNChangeEvent2.getUpdates(), this.lofResult);
            } else {
                throw new UnsupportedOperationException("Unsupported event type: " + (Object)((Object)kNNChangeEvent.getType()));
            }
        }

        private void kNNsInserted(DBIDs dBIDs, DBIDs dBIDs2, DBIDs dBIDs3, FlexibleLOF.LOFResult<O> lOFResult) {
            StepProgress stepProgress;
            StepProgress stepProgress2 = stepProgress = LOG.isVerbose() ? new StepProgress(3) : null;
            if (stepProgress != null) {
                stepProgress.beginStep(1, "Recompute LRDs.", LOG);
            }
            ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(DBIDUtil.union(dBIDs, dBIDs3));
            List<DoubleDBIDList> list = lOFResult.getRkNNReach().getRKNNForBulkDBIDs(arrayDBIDs, OnlineLOF.this.kreach);
            ArrayModifiableDBIDs arrayModifiableDBIDs = this.mergeIDs(list, arrayDBIDs);
            ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(arrayModifiableDBIDs.size());
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayModifiableDBIDs, 3);
            OnlineLOF.this.computeLRDs(lOFResult.getKNNReach(), arrayModifiableDBIDs, writableDoubleDataStore);
            Object object = arrayModifiableDBIDs.iter();
            while (object.valid()) {
                double d = writableDoubleDataStore.doubleValue((DBIDRef)object);
                double d2 = lOFResult.getLrds().doubleValue((DBIDRef)object);
                if (Double.isNaN(d2) || d2 != d) {
                    lOFResult.getLrds().putDouble((DBIDRef)object, d);
                    arrayModifiableDBIDs2.add((DBIDRef)object);
                }
                object.advance();
            }
            if (stepProgress != null) {
                stepProgress.beginStep(2, "Recompute LOFS.", LOG);
            }
            object = lOFResult.getRkNNRefer().getRKNNForBulkDBIDs(arrayModifiableDBIDs2, OnlineLOF.this.krefer);
            ArrayModifiableDBIDs arrayModifiableDBIDs3 = this.mergeIDs((List<? extends DoubleDBIDList>)object, arrayModifiableDBIDs2, dBIDs, dBIDs2);
            this.recomputeLOFs(arrayModifiableDBIDs3, lOFResult);
            if (stepProgress != null) {
                stepProgress.beginStep(3, "Inform listeners.", LOG);
            }
            lOFResult.getResult().getHierarchy().resultChanged(lOFResult.getResult());
            LOG.setCompleted(stepProgress);
        }

        private void kNNsRemoved(DBIDs dBIDs, DBIDs dBIDs2, DBIDs dBIDs3, FlexibleLOF.LOFResult<O> lOFResult) {
            StepProgress stepProgress;
            StepProgress stepProgress2 = stepProgress = LOG.isVerbose() ? new StepProgress(4) : null;
            if (stepProgress != null) {
                stepProgress.beginStep(1, "Delete old LRDs and LOFs.", LOG);
            }
            Object object = dBIDs.iter();
            while (object.valid()) {
                lOFResult.getLrds().delete((DBIDRef)object);
                lOFResult.getLofs().delete((DBIDRef)object);
                object.advance();
            }
            if (stepProgress != null) {
                stepProgress.beginStep(2, "Recompute LRDs.", LOG);
            }
            object = DBIDUtil.ensureArray(dBIDs3);
            List<DoubleDBIDList> list = lOFResult.getRkNNReach().getRKNNForBulkDBIDs((ArrayDBIDs)object, OnlineLOF.this.kreach);
            ArrayModifiableDBIDs arrayModifiableDBIDs = this.mergeIDs(list, new DBIDs[]{object});
            ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(arrayModifiableDBIDs.size());
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayModifiableDBIDs, 3);
            OnlineLOF.this.computeLRDs(lOFResult.getKNNReach(), arrayModifiableDBIDs, writableDoubleDataStore);
            Object object2 = arrayModifiableDBIDs.iter();
            while (object2.valid()) {
                double d = writableDoubleDataStore.doubleValue((DBIDRef)object2);
                double d2 = lOFResult.getLrds().doubleValue((DBIDRef)object2);
                if (d2 != d) {
                    lOFResult.getLrds().putDouble((DBIDRef)object2, d);
                    arrayModifiableDBIDs2.add((DBIDRef)object2);
                }
                object2.advance();
            }
            if (stepProgress != null) {
                stepProgress.beginStep(3, "Recompute LOFS.", LOG);
            }
            object2 = lOFResult.getRkNNRefer().getRKNNForBulkDBIDs(arrayModifiableDBIDs2, OnlineLOF.this.krefer);
            ArrayModifiableDBIDs arrayModifiableDBIDs3 = this.mergeIDs((List<? extends DoubleDBIDList>)object2, arrayModifiableDBIDs2, dBIDs2);
            this.recomputeLOFs(arrayModifiableDBIDs3, lOFResult);
            if (stepProgress != null) {
                stepProgress.beginStep(4, "Inform listeners.", LOG);
            }
            lOFResult.getResult().getHierarchy().resultChanged(lOFResult.getResult());
            LOG.setCompleted(stepProgress);
        }

        private ArrayModifiableDBIDs mergeIDs(List<? extends DoubleDBIDList> list, DBIDs ... dBIDsArray) {
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            for (DBIDs dBIDs : dBIDsArray) {
                hashSetModifiableDBIDs.addDBIDs(dBIDs);
            }
            for (DoubleDBIDList doubleDBIDList : list) {
                hashSetModifiableDBIDs.addDBIDs(doubleDBIDList);
            }
            return DBIDUtil.newArray(hashSetModifiableDBIDs);
        }

        private void recomputeLOFs(DBIDs dBIDs, FlexibleLOF.LOFResult<O> lOFResult) {
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            OnlineLOF.this.computeLOFs(lOFResult.getKNNRefer(), dBIDs, lOFResult.getLrds(), writableDoubleDataStore, doubleMinMax);
            Object object = dBIDs.iter();
            while (object.valid()) {
                lOFResult.getLofs().putDouble((DBIDRef)object, writableDoubleDataStore.doubleValue((DBIDRef)object));
                object.advance();
            }
            if (doubleMinMax.isValid()) {
                if (lOFResult.getResult().getOutlierMeta().getActualMaximum() < doubleMinMax.getMax()) {
                    object = (BasicOutlierScoreMeta)lOFResult.getResult().getOutlierMeta();
                    ((BasicOutlierScoreMeta)object).setActualMaximum(doubleMinMax.getMax());
                }
                if (lOFResult.getResult().getOutlierMeta().getActualMinimum() > doubleMinMax.getMin()) {
                    object = (BasicOutlierScoreMeta)lOFResult.getResult().getOutlierMeta();
                    ((BasicOutlierScoreMeta)object).setActualMinimum(doubleMinMax.getMin());
                }
            }
        }
    }
}

