/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="LOF: Local Outlier Factor")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="M. M. Breunig, H.-P. Kriegel, R. Ng, and J. Sander", title="LOF: Identifying Density-Based Local Outliers", booktitle="Proc. 2nd ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '00), Dallas, TX, 2000", url="http://dx.doi.org/10.1145/342009.335388")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LOF"})
public class LOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LOF.class);
    protected int k;

    public LOF(int n, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("LOF", 3) : null;
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 1, "Materializing nearest-neighbor sets.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Computing Local Reachability Densities (LRD).");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.computeLRDs(kNNQuery, dBIDs, writableDoubleDataStore);
        LOG.beginStep(stepProgress, 3, "Computing Local Outlier Factors (LOF).");
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeLOFScores(kNNQuery, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, doubleMinMax);
        LOG.setCompleted(stepProgress);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Local Outlier Factor", "lof-outlier", writableDoubleDataStore2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
    }

    private void computeLRDs(KNNQuery<O> kNNQuery, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Local Reachability Densities (LRD)", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = this.computeLRD(kNNQuery, dBIDIter);
            writableDoubleDataStore.putDouble(dBIDIter, d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected double computeLRD(KNNQuery<O> kNNQuery, DBIDIter dBIDIter) {
        KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
        double d = 0.0;
        int n = 0;
        DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
        while (doubleDBIDListIter.valid()) {
            if (!DBIDUtil.equal(dBIDIter, doubleDBIDListIter)) {
                KNNList kNNList2 = kNNQuery.getKNNForDBID(doubleDBIDListIter, this.k);
                d += MathUtil.max(doubleDBIDListIter.doubleValue(), kNNList2.getKNNDistance());
                ++n;
            }
            doubleDBIDListIter.advance();
        }
        return d > 0.0 ? (double)n / d : Double.POSITIVE_INFINITY;
    }

    private void computeLOFScores(KNNQuery<O> kNNQuery, DBIDs dBIDs, DoubleDataStore doubleDataStore, WritableDoubleDataStore writableDoubleDataStore, DoubleMinMax doubleMinMax) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Local Outlier Factor (LOF) scores", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = this.computeLOFScore(kNNQuery, dBIDIter, doubleDataStore);
            writableDoubleDataStore.putDouble(dBIDIter, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected double computeLOFScore(KNNQuery<O> kNNQuery, DBIDRef dBIDRef, DoubleDataStore doubleDataStore) {
        double d = doubleDataStore.doubleValue(dBIDRef);
        if (Double.isInfinite(d)) {
            return 1.0;
        }
        double d2 = 0.0;
        int n = 0;
        KNNList kNNList = kNNQuery.getKNNForDBID(dBIDRef, this.k);
        DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
        while (doubleDBIDListIter.valid()) {
            if (!DBIDUtil.equal(dBIDRef, doubleDBIDListIter)) {
                d2 += doubleDataStore.doubleValue(doubleDBIDListIter);
                ++n;
            }
            doubleDBIDListIter.advance();
        }
        return d2 / (d * (double)n);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("lof.k", "The number of nearest neighbors (not including the query point) of an object to be considered for computing its LOF score.");
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected LOF<O> makeInstance() {
            return new LOF(this.k, this.distanceFunction);
        }
    }
}

