/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="L. J. Latecki, A. Lazarevic, D. Pokrajac", title="Outlier Detection with Kernel Density Functions", booktitle="Machine Learning and Data Mining in Pattern Recognition", url="http://dx.doi.org/10.1007/978-3-540-73499-4_6")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LDF"})
public class LDF<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDF.class);
    protected int k;
    protected double h = 1.0;
    protected double c = 0.1;
    private KernelDensityFunction kernel;

    public LDF(int n, DistanceFunction<? super O> distanceFunction, KernelDensityFunction kernelDensityFunction, double d, double d2) {
        super(distanceFunction);
        this.k = n + 1;
        this.kernel = kernelDensityFunction;
        this.h = d;
        this.c = d2;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        Object object2;
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("LDF", 3) : null;
        int n = RelationUtil.dimensionality(relation);
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Computing LDEs.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Densities", dBIDs.size(), LOG) : null;
        Object object3 = dBIDs.iter();
        while (object3.valid()) {
            object2 = kNNQuery.getKNNForDBID((DBIDRef)object3, this.k);
            double d = 0.0;
            int n2 = 0;
            object = object2.iter();
            while (object.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object, (DBIDRef)object3)) {
                    double d2 = kNNQuery.getKNNForDBID((DBIDRef)object, this.k).getKNNDistance();
                    if (!(d2 > 0.0) || d2 == Double.POSITIVE_INFINITY) {
                        d = Double.POSITIVE_INFINITY;
                        ++n2;
                        break;
                    }
                    double d3 = MathUtil.max(d2, object.doubleValue()) / (this.h * d2);
                    d += this.kernel.density(d3) / MathUtil.powi(this.h * d2, n);
                    ++n2;
                }
                object.advance();
            }
            writableDoubleDataStore.putDouble((DBIDRef)object3, d / (double)n2);
            LOG.incrementProcessed(finiteProgress);
            object3.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.beginStep(stepProgress, 3, "Computing LDFs.");
        object3 = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        object2 = new DoubleMinMax();
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Local Density Factors", dBIDs.size(), LOG) : null;
        Object object4 = dBIDs.iter();
        while (object4.valid()) {
            double d = writableDoubleDataStore.doubleValue((DBIDRef)object4);
            KNNList kNNList = kNNQuery.getKNNForDBID((DBIDRef)object4, this.k);
            double d4 = 0.0;
            int n3 = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, (DBIDRef)object4)) {
                    d4 += writableDoubleDataStore.doubleValue(doubleDBIDListIter);
                    ++n3;
                }
                doubleDBIDListIter.advance();
            }
            double d5 = d + this.c * (d4 /= (double)n3);
            double d6 = d5 == Double.POSITIVE_INFINITY ? (d4 < Double.POSITIVE_INFINITY ? 0.0 : 1.0) : (d5 > 0.0 ? d4 / d5 : 0.0);
            object3.putDouble((DBIDRef)object4, d6);
            ((DoubleMinMax)object2).put(d6);
            LOG.incrementProcessed(finiteProgress2);
            object4.advance();
        }
        LOG.ensureCompleted(finiteProgress2);
        LOG.setCompleted(stepProgress);
        object4 = new MaterializedDoubleRelation("Local Density Factor", "ldf-outlier", (DoubleDataStore)object3, dBIDs);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object2).getMin(), ((DoubleMinMax)object2).getMax(), 0.0, 1.0 / this.c, 1.0 / (1.0 + this.c));
        object = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object4);
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KERNEL_ID = new OptionID("ldf.kernel", "Kernel to use for LDF.");
        public static final OptionID K_ID = new OptionID("ldf.k", "Number of neighbors to use for LDF.");
        public static final OptionID H_ID = new OptionID("ldf.h", "Kernel bandwidth multiplier for LDF.");
        public static final OptionID C_ID = new OptionID("ldf.c", "Score scaling parameter for LDF.");
        protected int k = 2;
        KernelDensityFunction kernel;
        protected double h = 1.0;
        protected double c = 0.1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, GaussianKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(H_ID))) {
                this.h = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(C_ID, 0.1))) {
                this.c = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LDF<O> makeInstance() {
            return new LDF(this.k, this.distanceFunction, this.kernel, this.h, this.c);
        }
    }
}

