/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.HillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Jonathan von Br\u00fcnken, Michael E. Houle, Arthur Zimek", title="Intrinsic Dimensional Outlier Detection in High-Dimensional Data", booktitle="NII Technical Report (NII-2015-003E)", url="http://www.nii.ac.jp/TechReports/15-003E.html")
public class IDOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(IDOS.class);
    protected int k_c;
    protected int k_r;
    protected IntrinsicDimensionalityEstimator estimator;

    public IDOS(DistanceFunction<? super O> distanceFunction, IntrinsicDimensionalityEstimator intrinsicDimensionalityEstimator, int n, int n2) {
        super(distanceFunction);
        this.estimator = intrinsicDimensionalityEstimator;
        this.k_c = n;
        this.k_r = n2;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress;
        StepProgress stepProgress2 = stepProgress = LOG.isVerbose() ? new StepProgress("IDOS", 3) : null;
        if (stepProgress != null) {
            stepProgress.beginStep(1, "Precomputing neighborhoods", LOG);
        }
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), Math.max(this.k_c, this.k_r) + 1);
        DBIDs dBIDs = relation.getDBIDs();
        if (stepProgress != null) {
            stepProgress.beginStep(2, "Computing intrinsic dimensionalities", LOG);
        }
        DoubleDataStore doubleDataStore = this.computeIDs(dBIDs, kNNQuery);
        if (stepProgress != null) {
            stepProgress.beginStep(3, "Computing IDOS scores", LOG);
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleDataStore doubleDataStore2 = this.computeIDOS(dBIDs, kNNQuery, doubleDataStore, doubleMinMax);
        if (stepProgress != null) {
            stepProgress.setCompleted(LOG);
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Intrinsic Dimensionality Outlier Score", "idos", doubleDataStore2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
    }

    protected DoubleDataStore computeIDs(DBIDs dBIDs, KNNQuery<O> kNNQuery) {
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Intrinsic dimensionality", dBIDs.size(), LOG) : null;
        double[] dArray = new double[this.k_c];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k_c + 1);
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                double d = doubleDBIDListIter.doubleValue();
                if (d > 0.0) {
                    dArray[n++] = d;
                }
                if (n >= this.k_c) break;
                doubleDBIDListIter.advance();
            }
            double d = 0.0;
            try {
                d = n > 1 ? this.estimator.estimate(dArray, n) : 0.0;
            }
            catch (ArithmeticException arithmeticException) {
                d = 0.0;
            }
            writableDoubleDataStore.putDouble(dBIDIter, d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return writableDoubleDataStore;
    }

    protected DoubleDataStore computeIDOS(DBIDs dBIDs, KNNQuery<O> kNNQuery, DoubleDataStore doubleDataStore, DoubleMinMax doubleMinMax) {
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("ID Outlier Scores for objects", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d;
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k_r);
            double d2 = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(dBIDIter, doubleDBIDListIter)) {
                    double d3 = doubleDataStore.doubleValue(doubleDBIDListIter);
                    d2 += d3 > 0.0 ? 1.0 / d3 : 0.0;
                    if (++n == this.k_r) break;
                }
                doubleDBIDListIter.advance();
            }
            double d4 = (d = doubleDataStore.doubleValue(dBIDIter)) > 0.0 ? d * d2 / (double)n : 0.0;
            writableDoubleDataStore.putDouble(dBIDIter, d4);
            doubleMinMax.put(d4);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return writableDoubleDataStore;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("idos.estimator", "Estimator of intrinsic dimensionality.");
        public static final OptionID KR_ID = new OptionID("idos.kr", "Reference set size.");
        public static final OptionID KC_ID = new OptionID("idos.kc", "Context set size (ID estimation).");
        protected IntrinsicDimensionalityEstimator estimator;
        protected int k_c = 20;
        protected int k_r = 20;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            IntParameter intParameter2;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, HillEstimator.class);
            if (parameterization.grab(objectParameter)) {
                this.estimator = (IntrinsicDimensionalityEstimator)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter2 = (IntParameter)new IntParameter(KC_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(5)))) {
                this.k_c = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(KR_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.k_r = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected IDOS<O> makeInstance() {
            return new IDOS(this.distanceFunction, this.estimator, this.k_c, this.k_r);
        }
    }
}

