/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.ReferencePointsResult;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.GridBasedReferencePoints;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.Collection;

@Title(value="An Efficient Reference-based Approach to Outlier Detection in Large Datasets")
@Description(value="Computes kNN distances approximately, using reference points with various reference point strategies.")
@Reference(authors="Y. Pei, O.R. Zaiane, Y. Gao", title="An Efficient Reference-based Approach to Outlier Detection in Large Datasets", booktitle="Proc. 6th IEEE Int. Conf. on Data Mining (ICDM '06)", url="http://dx.doi.org/10.1109/ICDM.2006.17")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ReferenceBasedOutlierDetection"})
public class ReferenceBasedOutlierDetection
extends AbstractNumberVectorDistanceBasedAlgorithm<NumberVector, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ReferenceBasedOutlierDetection.class);
    private int k;
    private ReferencePointsHeuristic refp;

    public ReferenceBasedOutlierDetection(int n, NumberVectorDistanceFunction<? super NumberVector> numberVectorDistanceFunction, ReferencePointsHeuristic referencePointsHeuristic) {
        super(numberVectorDistanceFunction);
        this.k = n;
        this.refp = referencePointsHeuristic;
    }

    public OutlierResult run(Database database, Relation<? extends NumberVector> relation) {
        PrimitiveDistanceQuery primitiveDistanceQuery = (PrimitiveDistanceQuery)database.getDistanceQuery(relation, this.distanceFunction, new Object[0]);
        Collection<? extends NumberVector> collection = this.refp.getReferencePoints(relation);
        if (collection.size() < 1) {
            throw new AbortException("Cannot compute ROS without reference points!");
        }
        DBIDs dBIDs = relation.getDBIDs();
        if (this.k >= dBIDs.size()) {
            throw new AbortException("k must not be chosen larger than the database size!");
        }
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 6, Double.NaN);
        for (NumberVector object2 : collection) {
            DoubleDBIDList doubleDBIDList = this.computeDistanceVector(object2, relation, primitiveDistanceQuery);
            this.updateDensities(writableDoubleDataStore, doubleDBIDList);
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DBIDIter d = relation.iterDBIDs();
        while (d.valid()) {
            doubleMinMax.put(writableDoubleDataStore.doubleValue(d));
            d.advance();
        }
        double d2 = doubleMinMax.getMax() > 0.0 ? 1.0 / doubleMinMax.getMax() : 1.0;
        doubleMinMax.reset();
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            double basicOutlierScoreMeta = 1.0 - writableDoubleDataStore.doubleValue((DBIDRef)object) * d2;
            doubleMinMax.put(basicOutlierScoreMeta);
            writableDoubleDataStore.putDouble((DBIDRef)object, basicOutlierScoreMeta);
            object.advance();
        }
        object = new MaterializedDoubleRelation("Reference-points Outlier Scores", "reference-outlier", writableDoubleDataStore, relation.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, 1.0, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
        outlierResult.addChildResult(new ReferencePointsResult<NumberVector>("Reference points", "reference-points", collection));
        return outlierResult;
    }

    protected DoubleDBIDList computeDistanceVector(NumberVector numberVector, Relation<? extends NumberVector> relation, PrimitiveDistanceQuery<? super NumberVector> primitiveDistanceQuery) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(relation.size());
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            modifiableDoubleDBIDList.add(primitiveDistanceQuery.distance((NumberVector)((Object)dBIDIter), numberVector), dBIDIter);
            dBIDIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    protected void updateDensities(WritableDoubleDataStore writableDoubleDataStore, DoubleDBIDList doubleDBIDList) {
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        for (int i = 0; i < doubleDBIDList.size(); ++i) {
            double d = this.computeDensity(doubleDBIDList, doubleDBIDListIter, i);
            doubleDBIDListIter.seek(i);
            if (d > writableDoubleDataStore.doubleValue(doubleDBIDListIter)) continue;
            writableDoubleDataStore.putDouble(doubleDBIDListIter, d);
        }
    }

    protected double computeDensity(DoubleDBIDList doubleDBIDList, DoubleDBIDListIter doubleDBIDListIter, int n) {
        int n2 = doubleDBIDList.size();
        double d = doubleDBIDListIter.seek(n).doubleValue();
        int n3 = n;
        int n4 = n;
        double d2 = 0.0;
        double d3 = --n3 >= 0 ? d - doubleDBIDListIter.seek(n3).doubleValue() : Double.POSITIVE_INFINITY;
        double d4 = ++n4 < n2 ? doubleDBIDListIter.seek(n4).doubleValue() - d : Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.k; ++i) {
            if (n3 >= 0 && n4 < n2) {
                if (d3 < d4) {
                    d2 += d3;
                    d3 = --n3 >= 0 ? d - doubleDBIDListIter.seek(n3).doubleValue() : Double.POSITIVE_INFINITY;
                    continue;
                }
                d2 += d4;
                d4 = ++n4 < n2 ? doubleDBIDListIter.seek(n4).doubleValue() - d : Double.POSITIVE_INFINITY;
                continue;
            }
            if (n3 >= 0) {
                d2 += d3;
                d3 = --n3 >= 0 ? d - doubleDBIDListIter.seek(n3).doubleValue() : Double.POSITIVE_INFINITY;
                continue;
            }
            if (n4 < n2) {
                d2 += d4;
                d4 = ++n4 < n2 ? doubleDBIDListIter.seek(n4).doubleValue() - d : Double.POSITIVE_INFINITY;
                continue;
            }
            throw new IndexOutOfBoundsException("Less than k objects?");
        }
        return (double)this.k / d2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.distanceFunction.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<NumberVector> {
        public static final OptionID REFP_ID = new OptionID("refod.refp", "The heuristic for finding reference points.");
        public static final OptionID K_ID = new OptionID("refod.k", "The number of nearest neighbors");
        private int k;
        private ReferencePointsHeuristic refp;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(REFP_ID, (Class<?>)ReferencePointsHeuristic.class, GridBasedReferencePoints.class))) {
                this.refp = (ReferencePointsHeuristic)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ReferenceBasedOutlierDetection makeInstance() {
            return new ReferenceBasedOutlierDetection(this.k, this.distanceFunction, this.refp);
        }
    }
}

